/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.decomposition;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.DoubleMatrix2D;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.impl.ArrayDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasDoubleArray2D;
import org.ujmp.core.util.UJMPSettings;

public class Ginv
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 1087531579133023922L;

    public Ginv(Matrix source) {
        super(source);
    }

    public static DenseDoubleMatrix2D times(DenseDoubleMatrix2D matrix1, DenseDoubleMatrix2D matrix2, long timesInner) {
        long timesRows = matrix1.getRowCount();
        long timesCols = matrix2.getColumnCount();
        DenseDoubleMatrix2D response = DenseDoubleMatrix2D.factory.dense(timesRows, timesCols);
        long row = 0L;
        while (row < timesRows) {
            long col = 0L;
            while (col < timesCols) {
                long inner = 0L;
                while (inner < timesInner) {
                    response.setDouble(matrix1.getAsDouble(row, inner) * matrix2.getDouble(inner, col) + response.getDouble(row, col), row, col);
                    ++inner;
                }
                ++col;
            }
            ++row;
        }
        return response;
    }

    public static double[][] times(double[][] matrix1, double[][] matrix2, int timesInner) {
        int timesRows = matrix1.length;
        int timesCols = matrix2[0].length;
        double[][] response = new double[timesRows][timesCols];
        int row = 0;
        while (row < timesRows) {
            int col = 0;
            while (col < timesCols) {
                int inner = 0;
                while (inner < timesInner) {
                    response[row][col] = matrix1[row][inner] * matrix2[inner][col] + response[row][col];
                    ++inner;
                }
                ++col;
            }
            ++row;
        }
        return response;
    }

    public static void swapCols(Matrix matrix, long col1, long col2) {
        double temp = 0.0;
        long rows = matrix.getRowCount();
        long row = 0L;
        while (row < rows) {
            temp = matrix.getAsDouble(row, col1);
            matrix.setAsDouble(matrix.getAsDouble(row, col2), row, col1);
            matrix.setAsDouble(temp, row++, col2);
        }
    }

    public static void swapCols(DenseDoubleMatrix2D matrix, long col1, long col2) {
        double temp = 0.0;
        long rows = matrix.getRowCount();
        long row = 0L;
        while (row < rows) {
            temp = matrix.getDouble(row, col1);
            matrix.setDouble(matrix.getDouble(row, col2), row, col1);
            matrix.setDouble(temp, row, col2);
            ++row;
        }
    }

    public static void swapCols(double[][] matrix, int col1, int col2) {
        double temp = 0.0;
        int rows = matrix.length;
        double[] r = null;
        int row = 0;
        while (row < rows) {
            r = matrix[row];
            temp = r[col1];
            r[col1] = r[col2];
            r[col2] = temp;
            ++row;
        }
    }

    public static void swapRows(Matrix matrix, long row1, long row2) {
        double temp = 0.0;
        long cols = matrix.getColumnCount();
        long col = 0L;
        while (col < cols) {
            temp = matrix.getAsDouble(row1, col);
            matrix.setAsDouble(matrix.getAsDouble(row2, col), row1, col);
            matrix.setAsDouble(temp, row2, col++);
        }
    }

    public static void swapRows(DenseDoubleMatrix2D matrix, long row1, long row2) {
        double temp = 0.0;
        long cols = matrix.getColumnCount();
        long col = 0L;
        while (col < cols) {
            temp = matrix.getDouble(row1, col);
            matrix.setDouble(matrix.getDouble(row2, col), row1, col);
            matrix.setDouble(temp, row2, col);
            ++col;
        }
    }

    public static void swapRows(double[][] matrix, int row1, int row2) {
        double[] temp = matrix[row1];
        matrix[row1] = matrix[row2];
        matrix[row2] = temp;
    }

    public static DenseDoubleMatrix2D inverse(Matrix matrix) {
        double epsilon = UJMPSettings.getTolerance();
        long rows = matrix.getRowCount();
        long cols = matrix.getColumnCount();
        DenseDoubleMatrix2D s = DoubleMatrix2D.factory.dense(cols, cols);
        s.eye(Calculation.Ret.ORIG);
        DenseDoubleMatrix2D t = DoubleMatrix2D.factory.dense(rows, rows);
        t.eye(Calculation.Ret.ORIG);
        long maxDiag = Math.min(rows, cols);
        int diag = 0;
        while ((long)diag < maxDiag) {
            double factor;
            Ginv.swapPivot(matrix, (long)diag, (Matrix)s, (Matrix)t);
            if (matrix.getAsDouble(diag, diag) == 0.0) break;
            long[] lArray = new long[]{diag, diag};
            double divisor = matrix.getAsDouble(lArray);
            if (Math.abs(divisor) < epsilon) {
                matrix.setAsDouble(0.0, diag, diag);
                break;
            }
            Ginv.divideRowBy(matrix, (long)diag, (long)diag, divisor);
            Ginv.divideRowBy(t, (long)diag, 0L, divisor);
            matrix.setAsDouble(1.0, diag, diag);
            long row = diag + 1;
            while (row < rows) {
                factor = matrix.getAsDouble(row, diag);
                if (factor != 0.0) {
                    Ginv.addRowTimes(matrix, (long)diag, (long)diag, row, factor);
                    Ginv.addRowTimes(t, (long)diag, 0L, row, factor);
                    matrix.setAsDouble(0.0, row, diag);
                }
                ++row;
            }
            long col = diag + 1;
            while (col < cols) {
                factor = matrix.getAsDouble(diag, col);
                if (factor != 0.0) {
                    Ginv.addColTimes(matrix, (long)diag, (long)diag, col, factor);
                    Ginv.addColTimes(s, (long)diag, 0L, col, factor);
                    matrix.setAsDouble(0.0, diag, col);
                }
                ++col;
            }
            ++diag;
        }
        return Ginv.times(s, t, (long)diag);
    }

    public static DenseDoubleMatrix2D inverse(DenseDoubleMatrix2D matrix) {
        double epsilon = UJMPSettings.getTolerance();
        long rows = matrix.getRowCount();
        long cols = matrix.getColumnCount();
        DenseDoubleMatrix2D s = DoubleMatrix2D.factory.dense(cols, cols);
        s.eye(Calculation.Ret.ORIG);
        DenseDoubleMatrix2D t = DoubleMatrix2D.factory.dense(rows, rows);
        t.eye(Calculation.Ret.ORIG);
        long maxDiag = Math.min(rows, cols);
        int diag = 0;
        while ((long)diag < maxDiag) {
            double factor;
            Ginv.swapPivot(matrix, (long)diag, s, t);
            if (matrix.getAsDouble(diag, diag) == 0.0) break;
            long[] lArray = new long[]{diag, diag};
            double divisor = matrix.getAsDouble(lArray);
            if (Math.abs(divisor) < epsilon) {
                matrix.setDouble(0.0, diag, diag);
                break;
            }
            Ginv.divideRowBy(matrix, (long)diag, (long)diag, divisor);
            Ginv.divideRowBy(t, (long)diag, 0L, divisor);
            matrix.setDouble(1.0, diag, diag);
            long row = diag + 1;
            while (row < rows) {
                factor = matrix.getDouble(row, (long)diag);
                if (factor != 0.0) {
                    Ginv.addRowTimes(matrix, (long)diag, (long)diag, row, factor);
                    Ginv.addRowTimes(t, (long)diag, 0L, row, factor);
                    matrix.setDouble(0.0, row, (long)diag);
                }
                ++row;
            }
            long col = diag + 1;
            while (col < cols) {
                factor = matrix.getDouble((long)diag, col);
                if (factor != 0.0) {
                    Ginv.addColTimes(matrix, (long)diag, (long)diag, col, factor);
                    Ginv.addColTimes(s, (long)diag, 0L, col, factor);
                    matrix.setDouble(0.0, (long)diag, col);
                }
                ++col;
            }
            ++diag;
        }
        return Ginv.times(s, t, (long)diag);
    }

    public static DenseDoubleMatrix2D inverse(double[][] matrix) {
        double epsilon = UJMPSettings.getTolerance();
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] s = new double[cols][cols];
        int c = 0;
        while (c < cols) {
            s[c][c] = 1.0;
            ++c;
        }
        double[][] t = new double[rows][rows];
        int r = 0;
        while (r < rows) {
            t[r][r] = 1.0;
            ++r;
        }
        int maxDiag = Math.min(rows, cols);
        int diag = 0;
        while (diag < maxDiag) {
            double factor;
            Ginv.swapPivot(matrix, diag, s, t);
            if (matrix[diag][diag] == 0.0) break;
            double divisor = matrix[diag][diag];
            if (Math.abs(divisor) < epsilon) {
                matrix[diag][diag] = 0.0;
                break;
            }
            Ginv.divideRowBy(matrix, diag, diag, divisor);
            Ginv.divideRowBy(t, diag, 0, divisor);
            matrix[diag][diag] = 1.0;
            int row = diag + 1;
            while (row < rows) {
                factor = matrix[row][diag];
                if (factor != 0.0) {
                    Ginv.addRowTimes(matrix, diag, diag, row, factor);
                    Ginv.addRowTimes(t, diag, 0, row, factor);
                    matrix[row][diag] = 0.0;
                }
                ++row;
            }
            int col = diag + 1;
            while (col < cols) {
                factor = matrix[diag][col];
                if (factor != 0.0) {
                    Ginv.addColTimes(matrix, diag, diag, col, factor);
                    Ginv.addColTimes(s, diag, 0, col, factor);
                    matrix[diag][col] = 0.0;
                }
                ++col;
            }
            ++diag;
        }
        double[][] result = Ginv.times(s, t, diag);
        return new ArrayDenseDoubleMatrix2D(result);
    }

    public static void addColTimes(Matrix matrix, long diag, long fromRow, long col, double factor) {
        long rows = matrix.getRowCount();
        long row = fromRow;
        while (row < rows) {
            matrix.setAsDouble(matrix.getAsDouble(row, col) - factor * matrix.getAsDouble(row, diag), row++, col);
        }
    }

    public static void addColTimes(double[][] matrix, int diag, int fromRow, int col, double factor) {
        int rows = matrix.length;
        double[] r = null;
        int row = fromRow;
        while (row < rows) {
            r = matrix[row];
            int n = col;
            r[n] = r[n] - factor * r[diag];
            ++row;
        }
    }

    public static void addColTimes(DenseDoubleMatrix2D matrix, long diag, long fromRow, long col, double factor) {
        long rows = matrix.getRowCount();
        long row = fromRow;
        while (row < rows) {
            matrix.setDouble(matrix.getDouble(row, col) - factor * matrix.getDouble(row, diag), row, col);
            ++row;
        }
    }

    public static void addRowTimes(DenseDoubleMatrix2D matrix, long diag, long fromCol, long row, double factor) {
        long cols = matrix.getColumnCount();
        long col = fromCol;
        while (col < cols) {
            matrix.setDouble(matrix.getDouble(row, col) - factor * matrix.getDouble(diag, col), row, col);
            ++col;
        }
    }

    public static void addRowTimes(double[][] matrix, int diag, int fromCol, int row, double factor) {
        int cols = matrix[0].length;
        double[] d = matrix[diag];
        double[] r = matrix[row];
        int col = fromCol;
        while (col < cols) {
            int n = col;
            r[n] = r[n] - factor * d[col];
            ++col;
        }
    }

    public static void addRowTimes(Matrix matrix, long diag, long fromCol, long row, double factor) {
        long cols = matrix.getColumnCount();
        long col = fromCol;
        while (col < cols) {
            matrix.setAsDouble(matrix.getAsDouble(row, col) - factor * matrix.getAsDouble(diag, col), row, col++);
        }
    }

    public static void divideRowBy(Matrix matrix, long aRow, long fromCol, double value) {
        long cols = matrix.getColumnCount();
        long col = fromCol;
        while (col < cols) {
            matrix.setAsDouble(matrix.getAsDouble(aRow, col) / value, aRow, col++);
        }
    }

    public static void divideRowBy(DenseDoubleMatrix2D matrix, long aRow, long fromCol, double value) {
        long cols = matrix.getColumnCount();
        long col = fromCol;
        while (col < cols) {
            matrix.setDouble(matrix.getDouble(aRow, col) / value, aRow, col);
            ++col;
        }
    }

    public static void divideRowBy(double[][] matrix, int aRow, int fromCol, double value) {
        int cols = matrix[0].length;
        double[] r = matrix[aRow];
        int col = fromCol;
        while (col < cols) {
            int n = col++;
            r[n] = r[n] / value;
        }
    }

    public static void swapPivot(Matrix source, long diag, Matrix s, Matrix t) {
        long swapRow = diag;
        long swapCol = diag;
        double maxValue = Math.abs(source.getAsDouble(diag, diag));
        long rows = source.getRowCount();
        long cols = source.getColumnCount();
        double abs = 0.0;
        long row = diag;
        while (row < rows) {
            long col = diag;
            while (col < cols) {
                long[] lArray = new long[]{row, col};
                abs = Math.abs(source.getAsDouble(lArray));
                if (abs > maxValue) {
                    maxValue = abs;
                    swapRow = row;
                    swapCol = col;
                }
                ++col;
            }
            ++row;
        }
        if (swapRow != diag) {
            Ginv.swapRows(source, swapRow, diag);
            Ginv.swapRows(t, swapRow, diag);
        }
        if (swapCol != diag) {
            Ginv.swapCols(source, swapCol, diag);
            Ginv.swapCols(s, swapCol, diag);
        }
    }

    public static void swapPivot(DenseDoubleMatrix2D source, long diag, DenseDoubleMatrix2D s, DenseDoubleMatrix2D t) {
        long swapRow = diag;
        long swapCol = diag;
        double maxValue = Math.abs(source.getDouble(diag, diag));
        long rows = source.getRowCount();
        long cols = source.getColumnCount();
        double abs = 0.0;
        long row = diag;
        while (row < rows) {
            long col = diag;
            while (col < cols) {
                abs = Math.abs(source.getDouble(row, col));
                if (abs > maxValue) {
                    maxValue = abs;
                    swapRow = row;
                    swapCol = col;
                }
                ++col;
            }
            ++row;
        }
        if (swapRow != diag) {
            Ginv.swapRows(source, swapRow, diag);
            Ginv.swapRows(t, swapRow, diag);
        }
        if (swapCol != diag) {
            Ginv.swapCols(source, swapCol, diag);
            Ginv.swapCols(s, swapCol, diag);
        }
    }

    public static void swapPivot(double[][] source, int diag, double[][] s, double[][] t) {
        int swapRow = diag;
        int swapCol = diag;
        double maxValue = Math.abs(source[diag][diag]);
        int rows = source.length;
        int cols = source[0].length;
        double abs = 0.0;
        double[] r = null;
        int row = diag;
        while (row < rows) {
            r = source[row];
            int col = diag;
            while (col < cols) {
                abs = Math.abs(r[col]);
                if (abs > maxValue) {
                    maxValue = abs;
                    swapRow = row;
                    swapCol = col;
                }
                ++col;
            }
            ++row;
        }
        if (swapRow != diag) {
            Ginv.swapRows(source, swapRow, diag);
            Ginv.swapRows(t, swapRow, diag);
        }
        if (swapCol != diag) {
            Ginv.swapCols(source, swapCol, diag);
            Ginv.swapCols(s, swapCol, diag);
        }
    }

    public static boolean canSwapRows(Matrix matrix, int row1, int row2, int col1) {
        boolean response = true;
        int col = 0;
        while (col < col1) {
            if (0.0 == matrix.getAsDouble(row1, col) && 0.0 != matrix.getAsDouble(row2, col)) {
                response = false;
                break;
            }
            ++col;
        }
        return response;
    }

    public static boolean canSwapCols(Matrix matrix, int col1, int col2, int row1) {
        boolean response = true;
        int row = row1 + 1;
        while ((long)row < matrix.getRowCount()) {
            if (0.0 == matrix.getAsDouble(row, col1) && 0.0 != matrix.getAsDouble(row, col2)) {
                response = false;
                break;
            }
            ++row;
        }
        return response;
    }

    public static Matrix reduce(Matrix source, Matrix response) {
        if (source.getRowCount() == source.getColumnCount()) {
            int col = 0;
            while ((long)col < source.getColumnCount() - 1L) {
                int rowData = (int)source.getRowCount() - 1;
                while (rowData > col) {
                    if (0.0 != source.getAsDouble(rowData, col)) {
                        int rowEmpty = rowData - 1;
                        while (rowEmpty > col) {
                            if (0.0 == source.getAsDouble(rowEmpty, col) && Ginv.canSwapRows(source, rowData, rowEmpty, col)) {
                                Ginv.swapRows(source, (long)rowData, (long)rowEmpty);
                                Ginv.swapCols(source, (long)rowData, (long)rowEmpty);
                                Ginv.swapRows(response, (long)rowData, (long)rowEmpty);
                                break;
                            }
                            --rowEmpty;
                        }
                    }
                    --rowData;
                }
                ++col;
            }
            int row = (int)source.getRowCount() - 1;
            while (row > 0) {
                int colData = 0;
                while (colData < row - 1) {
                    if (0.0 != source.getAsDouble(row, colData)) {
                        int colEmpty = colData + 1;
                        while (colEmpty < row) {
                            if (0.0 == source.getAsDouble(row, colEmpty) && Ginv.canSwapCols(source, colData, colEmpty, row)) {
                                Ginv.swapRows(source, (long)colData, (long)colEmpty);
                                Ginv.swapCols(source, (long)colData, (long)colEmpty);
                                Ginv.swapRows(response, (long)colData, (long)colEmpty);
                                break;
                            }
                            ++colEmpty;
                        }
                    }
                    ++colData;
                }
                --row;
            }
        }
        return response;
    }

    public static Matrix reduce(Matrix source) {
        Matrix response = MatrixFactory.dense(source.getRowCount(), 1L);
        int row = 0;
        while ((long)row < source.getRowCount()) {
            response.setAsDouble(row, row, 0L);
            ++row;
        }
        return source.getRowCount() == source.getColumnCount() ? Ginv.reduce(source, response) : response;
    }

    public static Matrix arbitrariness(Matrix source, Matrix inverse) {
        Matrix intermediate = inverse.mtimes(source);
        return MatrixFactory.eye(intermediate.getSize()).minus(intermediate);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        throw new MatrixException("this method should never be called: LINK not possible");
    }

    public DenseDoubleMatrix2D calcLink() throws MatrixException {
        throw new MatrixException("linking not possible, use ORIG or NEW");
    }

    public DenseDoubleMatrix2D calcNew() throws MatrixException {
        Matrix source = this.getSource();
        ArrayDenseDoubleMatrix2D matrix = new ArrayDenseDoubleMatrix2D(source);
        return Ginv.inverse(matrix.getDoubleArray2D());
    }

    public DenseDoubleMatrix2D calcOrig() throws MatrixException {
        Matrix source = this.getSource();
        if (!source.isSquare()) {
            throw new MatrixException("ORIG only possible for square matrices");
        }
        if (source instanceof HasDoubleArray2D) {
            return Ginv.inverse(((HasDoubleArray2D)((Object)source)).getDoubleArray2D());
        }
        if (source instanceof DenseDoubleMatrix2D) {
            return Ginv.inverse((DenseDoubleMatrix2D)source);
        }
        return Ginv.inverse(source);
    }
}

