/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.misc.Center;
import org.ujmp.core.doublematrix.calculation.general.statistical.Std;
import org.ujmp.core.exceptions.MatrixException;

public class Standardize
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = 6454174968175712888L;
    private Matrix center = null;
    private Matrix sigma = null;
    private boolean ignoreNaN = false;

    public Standardize(boolean ignoreNaN, int dimension, Matrix matrix) {
        super(dimension, matrix);
        this.ignoreNaN = ignoreNaN;
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.center == null) {
            this.center = new Center(this.ignoreNaN, this.getDimension(), this.getSource()).calcNew();
        }
        if (this.sigma == null) {
            this.sigma = new Std(this.getDimension(), this.ignoreNaN, this.center).calcNew();
        }
        switch (this.getDimension()) {
            case 0x7FFFFFFF: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(0L, 0L);
            }
            case 0: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(0L, coordinates[1]);
            }
            case 1: {
                return this.center.getAsDouble(coordinates) / this.sigma.getAsDouble(coordinates[0], 0L);
            }
        }
        return Double.NaN;
    }
}

