/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.missingvalues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImputeKNN
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -4923873199518001578L;
    private Matrix distanceMatrix = null;
    private int k = 1;

    public ImputeKNN(Matrix matrix, Object ... parameters) {
        super(matrix);
        if (parameters.length != 0) {
            this.k = MathUtil.getInt(parameters[0]);
        }
    }

    private List<Integer> getCandidates(long ... coordinates) {
        ArrayList<Integer> candidates = new ArrayList<Integer>();
        int r = 0;
        while ((long)r < this.getSource().getRowCount()) {
            if (coordinates[0] != (long)r) {
                if (!MathUtil.isNaNOrInfinite(this.getSource().getAsDouble(r, coordinates[1]))) {
                    candidates.add(r);
                }
            }
            ++r;
        }
        return candidates;
    }

    private Matrix getDistanceMatrix() {
        Matrix distanceMatrix = MatrixFactory.zeros(this.getSource().getRowCount(), this.getSource().getRowCount());
        int r = 0;
        while ((long)r < this.getSource().getRowCount()) {
            int c = 0;
            while ((long)c < this.getSource().getRowCount()) {
                if (r != c) {
                    Matrix m1 = this.getSource().selectRows(Calculation.Ret.LINK, r);
                    Matrix m2 = this.getSource().selectRows(Calculation.Ret.LINK, c);
                    double dist = m1.euklideanDistanceTo(m2, true);
                    distanceMatrix.setAsDouble(dist, r, c);
                }
                ++c;
            }
            ++r;
        }
        return distanceMatrix;
    }

    private List<Sortable<Double, Matrix>> getSortedNeighbors(long ... coordinates) {
        ArrayList<Sortable<Double, Matrix>> neighbors = new ArrayList<Sortable<Double, Matrix>>();
        List<Integer> candidates = this.getCandidates(coordinates);
        for (int candidateRow : candidates) {
            double dist = this.distanceMatrix.getAsDouble(coordinates[0], candidateRow);
            Matrix candidate = this.getSource().selectRows(Calculation.Ret.LINK, candidateRow);
            neighbors.add(new Sortable<Double, Matrix>(dist, candidate));
        }
        Collections.sort(neighbors);
        return neighbors;
    }

    @Override
    public double getDouble(long ... coordinates) throws MatrixException {
        double value;
        if (this.distanceMatrix == null) {
            this.distanceMatrix = this.getDistanceMatrix();
        }
        if (MathUtil.isNaNOrInfinite(value = this.getSource().getAsDouble(coordinates))) {
            List<Sortable<Double, Matrix>> sortedNeighbors = this.getSortedNeighbors(coordinates);
            double sum = 0.0;
            int count = 0;
            for (Sortable<Double, Matrix> s : sortedNeighbors) {
                sum += s.getObject().getAsDouble(0L, coordinates[1]);
                if (++count == this.k) break;
            }
            return sum / (double)count;
        }
        return value;
    }
}

