/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.graphmatrix;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ujmp.core.collections.ArrayIndexList;
import org.ujmp.core.coordinates.CoordinateSetToLongWrapper;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.graphmatrix.AbstractGraphMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGraphMatrix<N, E>
extends AbstractGraphMatrix<N, E> {
    private static final long serialVersionUID = -6103776352324576412L;
    private final List<N> nodes = new ArrayIndexList<N>();
    private final Map<Coordinates, E> edges = new HashMap<Coordinates, E>();
    private final Map<Long, List<Long>> parents = new HashMap<Long, List<Long>>();
    private final Map<Long, List<Long>> children = new HashMap<Long, List<Long>>();
    private boolean directed = true;

    public DefaultGraphMatrix() {
    }

    public DefaultGraphMatrix(List<N> nodes) {
        this.nodes.addAll(nodes);
    }

    @Override
    public Collection<E> getEdgeList() {
        return this.edges.values();
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        return new CoordinateSetToLongWrapper(this.edges.keySet());
    }

    @Override
    public List<N> getNodeList() {
        return this.nodes;
    }

    @Override
    public void setDirectedEdge(E value, long node1, long node2) {
        this.edges.put(new Coordinates(node1, node2), value);
    }

    @Override
    public void addNode(N o) {
        this.nodes.add(o);
    }

    @Override
    public void removeEdge(long node1, long node2) {
        this.edges.remove(new Coordinates(node1, node2));
    }

    @Override
    public void removeNode(N o) {
        this.nodes.remove(o);
    }

    @Override
    public E getEdgeValue(long node1, long node2) {
        return this.edges.get(new Coordinates(node1, node2));
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public void addDirectedEdge(long node1, long node2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void addUndirectedEdge(long node1, long node2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void clear() {
        this.edges.clear();
        this.parents.clear();
        this.children.clear();
    }

    @Override
    public void addChild(N node, N child) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public int getChildCount(long nodeIndex) {
        List<Long> indices = this.children.get(nodeIndex);
        return indices == null ? 0 : indices.size();
    }

    @Override
    public N getNode(long index) {
        return this.nodes.get((int)index);
    }

    @Override
    public int getParentCount(long nodeIndex) {
        List<Long> indices = this.parents.get(nodeIndex);
        return indices == null ? 0 : indices.size();
    }

    @Override
    public List<Long> getParentIndices(long index) {
        List<Long> indices = this.parents.get(index);
        return indices == null ? Collections.EMPTY_LIST : indices;
    }

    @Override
    public List<Long> getChildIndices(long index) {
        List<Long> indices = this.children.get(index);
        return indices == null ? Collections.EMPTY_LIST : indices;
    }

    @Override
    public void insertNode(N node, long index) {
        this.nodes.add((int)index, node);
    }

    @Override
    public void removeDirectedEdge(long nodeIndex1, long nodeIndex2) {
        this.edges.remove(new Coordinates(nodeIndex1, nodeIndex2));
    }

    @Override
    public void removeNode(long node) {
        this.nodes.remove((int)node);
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    @Override
    public void setNode(N node, long index) {
        this.nodes.set((int)index, node);
    }

    @Override
    public void setObject(Object o, long row, long column) throws MatrixException {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void setObject(Object o, int row, int column) throws MatrixException {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void addEdge(N node1, N node2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void addEdge(long nodeIndex1, long nodeIndex2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void removeEdge(N node1, N node2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public void setEdge(E edgeObject, long nodeIndex1, long nodeIndex2) {
        int nmbOfNodes = this.nodes.size();
        if (nodeIndex1 >= (long)nmbOfNodes) {
            throw new MatrixException("accessed node " + nodeIndex1 + ", but only " + nmbOfNodes + " available");
        }
        if (nodeIndex2 >= (long)nmbOfNodes) {
            throw new MatrixException("accessed node " + nodeIndex2 + ", but only " + nmbOfNodes + " available");
        }
        this.edges.put(new Coordinates(nodeIndex1, nodeIndex2), edgeObject);
        List<Long> list = this.children.get(nodeIndex1);
        if (list == null) {
            list = new ArrayList<Long>();
            this.children.put(nodeIndex1, list);
        }
        list.add(nodeIndex2);
        list = this.parents.get(nodeIndex2);
        if (list == null) {
            list = new ArrayList<Long>();
            this.parents.put(nodeIndex2, list);
        }
        list.add(nodeIndex1);
    }

    @Override
    public void setEdge(E edgeObject, N node1, N node2) {
        throw new MatrixException("not implemented!");
    }

    @Override
    public ValueType getValueType() {
        return ValueType.OBJECT;
    }
}

