/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.impl.DefaultSparseObjectMatrix;
import org.ujmp.core.objectmatrix.stub.AbstractSparseObjectMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSparseColumnObjectMatrix2D
extends AbstractSparseObjectMatrix2D
implements Wrapper<Map<Long, Matrix>> {
    private static final long serialVersionUID = -1943118812754494387L;
    private long[] size = new long[]{1L, 1L};
    private Map<Long, Matrix> columns = new HashMap<Long, Matrix>();

    public DefaultSparseColumnObjectMatrix2D(long ... size) {
        this.setSize(size);
    }

    public DefaultSparseColumnObjectMatrix2D(Matrix m) {
        this.setSize(m.getSize());
        for (long[] c : m.availableCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    @Override
    public Object getObject(long row, long column) throws MatrixException {
        Matrix m = this.columns.get(column);
        return m == null ? null : m.getAsObject(row, 0L);
    }

    @Override
    public Object getObject(int row, int column) throws MatrixException {
        Matrix m = this.columns.get(column);
        return m == null ? null : m.getAsObject(row, 0L);
    }

    @Override
    public Iterable<long[]> availableCoordinates() {
        ArrayList<long[]> coordinates = new ArrayList<long[]>();
        for (Long i : this.columns.keySet()) {
            Matrix m = this.columns.get(i);
            for (long[] c : m.availableCoordinates()) {
                long[] lArray = new long[2];
                lArray[1] = i;
                coordinates.add(Coordinates.plus(c, lArray));
            }
        }
        return coordinates;
    }

    @Override
    public boolean contains(long ... coordinates) {
        if (Coordinates.isSmallerThan(coordinates, this.size)) {
            return this.getObject(coordinates) != null;
        }
        return false;
    }

    @Override
    public void setObject(Object o, long row, long column) throws MatrixException {
        Matrix m = this.columns.get(column);
        if (m == null) {
            m = new DefaultSparseObjectMatrix(this.getRowCount(), 1L);
            this.columns.put(column, m);
        }
        m.setAsObject(o, row, 0L);
    }

    @Override
    public void setObject(Object o, int row, int column) throws MatrixException {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    @Override
    public void setSize(long ... size) {
        if (this.size[0] != size[0]) {
            for (Matrix m : this.columns.values()) {
                m.setSize(size[0], 1L);
            }
        }
        this.size = size;
    }

    public Matrix getColumn(long column) {
        return this.columns.get((int)column);
    }

    @Override
    public Matrix max(Calculation.Ret returnType, int dimension) throws MatrixException {
        if (returnType == Calculation.Ret.NEW) {
            if (dimension == 0) {
                Matrix ret = MatrixFactory.zeros(1L, this.getColumnCount());
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{0L, c[1]};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, 0L, c[1]);
                }
                return ret;
            }
            if (dimension == 1) {
                Matrix ret = MatrixFactory.zeros(this.getRowCount(), 1L);
                for (long[] c : this.availableCoordinates()) {
                    double v = this.getAsDouble(c);
                    long[] lArray = new long[]{c[0], 0L};
                    if (!(v > ret.getAsDouble(lArray))) continue;
                    ret.setAsDouble(v, c[0], 0L);
                }
                return ret;
            }
        }
        throw new MatrixException("not supported");
    }

    @Override
    public Matrix selectColumns(Calculation.Ret returnType, long ... columns) throws MatrixException {
        if (returnType == Calculation.Ret.LINK && columns.length == 1) {
            return this.getColumn(columns[0]);
        }
        return super.selectColumns(returnType, columns);
    }

    @Override
    public Map<Long, Matrix> getWrappedObject() {
        return this.columns;
    }

    @Override
    public void setWrappedObject(Map<Long, Matrix> object) {
        this.columns = object;
    }
}

