/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.impl;

import java.util.Iterator;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractObjectMatrix;

public class ReshapedObjectMatrix
extends AbstractObjectMatrix {
    private static final long serialVersionUID = -4298270756453090584L;
    private Matrix source = null;
    private long[] newSize = null;
    private long[] oldSize = null;

    public ReshapedObjectMatrix(Matrix source, long ... newSize) {
        this.source = source;
        this.newSize = newSize;
        this.oldSize = source.getSize();
    }

    public boolean contains(long ... coordinates) {
        return false;
    }

    private long[] getOldCoordinates(long[] newCoordinates) {
        long[] oldCoordinates = Coordinates.copyOf(newCoordinates);
        long valueNumber = newCoordinates[0] * this.newSize[1] + newCoordinates[1];
        oldCoordinates[0] = valueNumber / this.oldSize[1];
        oldCoordinates[1] = valueNumber % this.oldSize[1];
        return oldCoordinates;
    }

    private long[] getNewCoordinates(long[] oldCoordinates) {
        long[] newCoordinates = Coordinates.copyOf(oldCoordinates);
        long valueNumber = oldCoordinates[0] * this.oldSize[1] + oldCoordinates[1];
        newCoordinates[0] = valueNumber / this.newSize[1];
        newCoordinates[1] = valueNumber % this.newSize[1];
        return newCoordinates;
    }

    public long[] getSize() {
        return this.newSize;
    }

    public double getAsDouble(long ... coordinates) throws MatrixException {
        return this.source.getAsDouble(this.getOldCoordinates(coordinates));
    }

    public Object getObject(long ... coordinates) throws MatrixException {
        return this.source.getAsObject(this.getOldCoordinates(coordinates));
    }

    public long getValueCount() {
        return this.source.getValueCount();
    }

    public boolean isReadOnly() {
        return this.source.isReadOnly();
    }

    public final Matrix.StorageType getStorageType() {
        return this.source.getStorageType();
    }

    public void setAsDouble(double value, long ... coordinates) throws MatrixException {
        this.source.setAsDouble(value, this.getOldCoordinates(coordinates));
    }

    public void setObject(Object value, long ... coordinates) throws MatrixException {
        this.source.setAsObject(value, this.getOldCoordinates(coordinates));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoordinateIterable
    implements Iterable<long[]> {
        private CoordinateIterable() {
        }

        @Override
        public Iterator<long[]> iterator() {
            return new CoordinateIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CoordinateIterator
    implements Iterator<long[]> {
        private final Iterator<long[]> iterator;

        private CoordinateIterator() {
            this.iterator = ReshapedObjectMatrix.this.source.allCoordinates().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public long[] next() {
            return ReshapedObjectMatrix.this.getNewCoordinates(this.iterator.next());
        }

        @Override
        public void remove() {
        }
    }
}

