/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.objectmatrix.stub;

import java.util.Map;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.CoordinateIterator2D;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.objectmatrix.ObjectMatrix2D;
import org.ujmp.core.objectmatrix.impl.DefaultDenseObjectMatrix2D;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;
import org.ujmp.core.util.MathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMapToTiledMatrix2DWrapper
extends AbstractDenseObjectMatrix2D
implements ObjectMatrix2D,
Wrapper<Map<Coordinates, ObjectMatrix2D>> {
    private static final long serialVersionUID = -7464578359102479614L;
    private long[] tileSize = new long[]{100L, 100L};
    private long[] size = null;

    public AbstractMapToTiledMatrix2DWrapper(Matrix m) {
        this.size = Coordinates.copyOf(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public AbstractMapToTiledMatrix2DWrapper(Matrix m, int maximumNumberOfEntries2) {
        this.size = Coordinates.copyOf(m.getSize());
        for (long[] c : m.allCoordinates()) {
            this.setObject(m.getAsObject(c), c);
        }
    }

    public AbstractMapToTiledMatrix2DWrapper(long ... size) {
        this.size = Coordinates.copyOf(size);
    }

    @Override
    public Object getObject(int row, int column) throws MatrixException {
        return this.getObject((long)row, (long)column);
    }

    @Override
    public Object getObject(long row, long column) throws MatrixException {
        Coordinates c = new Coordinates(row / this.tileSize[0], column / this.tileSize[1]);
        Matrix m = this.getMap().get(c);
        if (m == null) {
            return null;
        }
        return m.getAsObject(row % this.tileSize[0], column % this.tileSize[1]);
    }

    @Override
    public Map<Coordinates, ObjectMatrix2D> getWrappedObject() {
        return this.getMap();
    }

    public abstract Map<Coordinates, ObjectMatrix2D> getMap();

    @Override
    public void setWrappedObject(Map<Coordinates, ObjectMatrix2D> object) {
        this.setMap(object);
    }

    public abstract void setMap(Map<Coordinates, ObjectMatrix2D> var1);

    @Override
    public Iterable<long[]> allCoordinates() {
        return new CoordinateIterator2D(this.getSize());
    }

    @Override
    public final double getAsDouble(long ... coordinates) throws MatrixException {
        return MathUtil.getDouble(this.getObject(coordinates));
    }

    @Override
    public final void setAsDouble(double v, long ... coordinates) throws MatrixException {
        this.setObject((Object)v, coordinates);
    }

    @Override
    public void setObject(Object o, int row, int column) throws MatrixException {
        this.setObject(o, (long)row, (long)column);
    }

    @Override
    public void setObject(Object o, long row, long column) throws MatrixException {
        Coordinates c = new Coordinates(row / this.tileSize[0], column / this.tileSize[1]);
        ObjectMatrix2D m = this.getMap().get(c);
        if (m == null) {
            m = new DefaultDenseObjectMatrix2D(this.tileSize[0], this.tileSize[1]);
        }
        m.setObject(o, row % this.tileSize[0], column % this.tileSize[1]);
        this.getMap().put(c, m);
    }

    @Override
    public long[] getSize() {
        return this.size;
    }

    public long[] getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(long ... tileSize) {
        this.tileSize = tileSize;
    }
}

