/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.ujmp.core.collections.SoftHashMap;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.io.SeekableLineInputStream;

public class CSVMatrix
extends AbstractDenseStringMatrix2D {
    private static final long serialVersionUID = 6025235663309962730L;
    private String fieldDelimiter = "[,;\t]";
    private int columnCount = 0;
    private final boolean trimFields = true;
    private final boolean ignoreQuotationMarks = true;
    private final String quotation = "\"";
    private SeekableLineInputStream sli = null;
    private final Map<Long, String[]> rows = new SoftHashMap<Long, String[]>();

    public CSVMatrix(String file, Object ... parameters) throws IOException {
        this(new File(file), parameters);
    }

    public CSVMatrix(File file, Object ... parameters) throws IOException {
        if (parameters.length != 0 && parameters[0] instanceof String) {
            this.fieldDelimiter = (String)parameters[0];
        } else {
            System.out.println("You should specify the column separator to make sure that the file is parsed correctly.");
            System.out.println("Example: MatrixFactory.linkToFile(FileFormat.CSV, file, \";\")");
        }
        this.setLabel(file.getAbsolutePath());
        this.sli = new SeekableLineInputStream(file);
        int i = 0;
        while (i < 100) {
            String line = this.sli.readLine(MathUtil.nextInteger(0, this.sli.getLineCount() - 1));
            int c = line.split(this.fieldDelimiter).length;
            if (c > this.columnCount) {
                this.columnCount = c;
            }
            ++i;
        }
    }

    public long[] getSize() {
        return new long[]{this.sli.getLineCount(), this.columnCount};
    }

    public String getString(long row, long column) throws MatrixException {
        try {
            String[] fields = null;
            fields = this.rows.get(row);
            if (fields == null) {
                String line = this.sli.readLine((int)row);
                fields = line.split(this.fieldDelimiter);
                int i = 0;
                while (i < fields.length) {
                    fields[i] = fields[i].trim();
                    ++i;
                }
                i = 0;
                while (i < fields.length) {
                    String s = fields[i];
                    if (s.length() > 1 && s.startsWith("\"") && s.endsWith("\"")) {
                        fields[i] = s.substring(1, s.length() - 2);
                    }
                    ++i;
                }
                this.rows.put(row, fields);
            }
            if (fields.length > this.columnCount) {
                this.columnCount = fields.length;
            }
            if (column < (long)fields.length) {
                return fields[(int)column];
            }
        }
        catch (Exception e) {
            throw new MatrixException(e);
        }
        return null;
    }

    public void setString(String value, long row, long column) {
    }
}

