/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.util.UJMPFormat;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.io.IntelligentFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MathUtil {
    private static List<DateFormat> dateFormats = null;
    private static final double ROOT2PI = Math.sqrt(Math.PI * 2);
    private static long seed = System.nanoTime();
    private static Random random = new Random();

    static {
        try {
            random.setSeed(seed);
            dateFormats = new ArrayList<DateFormat>();
            dateFormats.add(DateFormat.getDateInstance(3, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(2, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(1, Locale.US));
            dateFormats.add(DateFormat.getDateInstance(3, Locale.GERMAN));
            dateFormats.add(DateFormat.getDateInstance(2, Locale.GERMAN));
            dateFormats.add(DateFormat.getDateInstance(1, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(3, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(2, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(1, Locale.US));
            dateFormats.add(DateFormat.getTimeInstance(3, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(2, Locale.GERMAN));
            dateFormats.add(DateFormat.getTimeInstance(1, Locale.GERMAN));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MathContext getDefaultMathContext() {
        return UJMPSettings.getDefaultMathContext();
    }

    public static String getMD5Sum(String text) throws NoSuchAlgorithmException {
        StringBuilder hexString = new StringBuilder();
        MessageDigest mdAlgorithm = MessageDigest.getInstance("MD5");
        mdAlgorithm.update(text.getBytes());
        byte[] digest = mdAlgorithm.digest();
        int i = 0;
        while (i < digest.length) {
            text = Integer.toHexString(0xFF & digest[i]);
            if (text.length() < 2) {
                text = "0" + text;
            }
            hexString.append(text);
            ++i;
        }
        hexString.trimToSize();
        return hexString.toString();
    }

    public static String getMD5Sum(File file) throws NoSuchAlgorithmException {
        StringBuilder hexString = new StringBuilder();
        MessageDigest mdAlgorithm = MessageDigest.getInstance("MD5");
        mdAlgorithm.update(IntelligentFileReader.readBytes(file));
        byte[] digest = mdAlgorithm.digest();
        String text = null;
        int i = 0;
        while (i < digest.length) {
            text = Integer.toHexString(0xFF & digest[i]);
            if (text.length() < 2) {
                text = "0" + text;
            }
            hexString.append(text);
            ++i;
        }
        hexString.trimToSize();
        return hexString.toString();
    }

    public static final Random getRandom() {
        return random;
    }

    public static final boolean xor(boolean b1, boolean b2) {
        if (!b1 && !b2) {
            return false;
        }
        if (!b1 && b2) {
            return true;
        }
        return b1 && !b2;
    }

    public static double[] logToProbs(double[] logs) {
        double[] probs = new double[logs.length];
        double sum = 0.0;
        int i = 0;
        while (i < probs.length) {
            probs[i] = Math.exp(logs[i]);
            sum += probs[i];
            ++i;
        }
        i = 0;
        while (i < probs.length) {
            probs[i] = probs[i] / sum;
            ++i;
        }
        return probs;
    }

    public static final long getSeed() {
        return seed;
    }

    public static final double round(double value, int decimals) {
        return (double)Math.round(value * Math.pow(10.0, decimals)) / Math.pow(10.0, decimals);
    }

    public static void setSeed(long seed) {
        MathUtil.seed = seed;
        random.setSeed(seed);
    }

    public static double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    public static double log10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static final double gauss(double mean, double sigma, double x) {
        return Math.exp(-0.5 * Math.pow((x - mean) / sigma, 2.0)) / (sigma * ROOT2PI);
    }

    public static final double artanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static final double nextGaussian(double mean, double sigma) {
        return sigma <= 0.0 ? 0.0 : sigma * random.nextGaussian() + mean;
    }

    public static final double nextUniform(double min, double max) {
        if (min == max) {
            max += Double.MIN_VALUE;
        }
        double r = random.nextDouble();
        while (r <= 0.0) {
            r = random.nextDouble();
        }
        return min + r * (max - min);
    }

    public static final int nextInteger(int min, int max) {
        if (min == max) {
            return min;
        }
        double r = random.nextDouble();
        return (int)(r * (double)max + (1.0 - r) * (double)min + r);
    }

    public static boolean isEventHappening(double probability) {
        return MathUtil.nextUniform(0.0, 1.0) < probability;
    }

    public static boolean nextBoolean() {
        return MathUtil.nextGaussian(0.0, 1.0) > 0.0;
    }

    public static double nextDouble() {
        return random.nextDouble();
    }

    public static double ignoreNaN(double v) {
        return Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY ? 0.0 : v;
    }

    public static boolean isNaNOrInfinite(double v) {
        return Double.isNaN(v) || v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public static boolean isNaNOrInfinite(Object o) {
        return Double.valueOf(Double.NaN).equals(o) || Double.valueOf(Double.POSITIVE_INFINITY).equals(o) || Double.valueOf(Double.NEGATIVE_INFINITY).equals(o);
    }

    public static final Matrix getMatrix(Object o) {
        if (o == null) {
            return MatrixFactory.EMPTYMATRIX;
        }
        if (o instanceof Matrix) {
            Matrix m = (Matrix)o;
            if (m.isScalar() && m.getAsObject(0L, 0L) instanceof Matrix) {
                return MathUtil.getMatrix(m.getAsObject(0L, 0L));
            }
            return m;
        }
        return MatrixFactory.linkToValue(o);
    }

    public static final Date getDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof Long) {
            return new Date((Long)o);
        }
        if (o instanceof String) {
            for (DateFormat df : dateFormats) {
                try {
                    return df.parse((String)o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return new Date(MathUtil.getLong(o));
    }

    public static final double getDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).doubleValue();
        }
        if ("true".equalsIgnoreCase(o.toString())) {
            return 1.0;
        }
        if ("false".equalsIgnoreCase(o.toString())) {
            return 0.0;
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static long[] collectionToLong(Collection<? extends Number> numbers) {
        long[] ret = new long[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.longValue();
        }
        return ret;
    }

    public static double[] collectionToDouble(Collection<? extends Number> numbers) {
        double[] ret = new double[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.doubleValue();
        }
        return ret;
    }

    public static int[] collectionToInt(Collection<? extends Number> numbers) {
        int[] ret = new int[numbers.size()];
        int i = 0;
        for (Number number : numbers) {
            ret[i++] = number.intValue();
        }
        return ret;
    }

    public static List<Long> toLongList(long[] numbers) {
        ArrayList<Long> ret = new ArrayList<Long>(numbers.length);
        int i = 0;
        while (i < numbers.length) {
            ret.add(numbers[i]);
            ++i;
        }
        return ret;
    }

    public static List<Long> toLongList(int[] numbers) {
        ArrayList<Long> ret = new ArrayList<Long>(numbers.length);
        int i = 0;
        while (i < numbers.length) {
            ret.add(Long.valueOf(numbers[i]));
            ++i;
        }
        return ret;
    }

    public static List<Double> toDoubleList(double[] numbers) {
        ArrayList<Double> ret = new ArrayList<Double>(numbers.length);
        int i = 0;
        while (i < numbers.length) {
            ret.add(numbers[i]);
            ++i;
        }
        return ret;
    }

    public static List<Double> toDoubleList(int[] numbers) {
        ArrayList<Double> ret = new ArrayList<Double>(numbers.length);
        int i = 0;
        while (i < numbers.length) {
            ret.add(Double.valueOf(numbers[i]));
            ++i;
        }
        return ret;
    }

    public static List<Double> toDoubleList(long[] numbers) {
        ArrayList<Double> ret = new ArrayList<Double>(numbers.length);
        int i = 0;
        while (i < numbers.length) {
            ret.add(Double.valueOf(numbers[i]));
            ++i;
        }
        return ret;
    }

    public static double[] toDoubleArray(int ... intArray) {
        int nmb = intArray.length;
        double[] ret = new double[nmb];
        int i = 0;
        while (i < nmb) {
            ret[i] = intArray[i];
            ++i;
        }
        return ret;
    }

    public static double[][] toDoubleArray(int[] ... intArray) {
        int rows = intArray.length;
        if (rows <= 0) {
            return new double[0][0];
        }
        int cols = intArray[0].length;
        double[][] ret = new double[rows][cols];
        int i = rows - 1;
        while (i >= 0) {
            int j = cols - 1;
            while (j >= 0) {
                ret[i][j] = intArray[i][j];
                --j;
            }
            --i;
        }
        return ret;
    }

    public static List<Long> sequenceListLong(long start, long end) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (start < end) {
            long l = start;
            while (l <= end) {
                list.add(l);
                ++l;
            }
        } else {
            long l = start;
            while (l >= end) {
                list.add(l);
                --l;
            }
        }
        return list;
    }

    public static List<Double> sequenceListDouble(double start, double end) {
        ArrayList<Double> list = new ArrayList<Double>();
        if (start < end) {
            double l = start;
            while (l <= end) {
                list.add(l);
                l += 1.0;
            }
        } else {
            double l = start;
            while (l >= end) {
                list.add(l);
                l -= 1.0;
            }
        }
        return list;
    }

    public static List<Integer> sequenceListInt(int start, int end) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (start < end) {
            int l = start;
            while (l <= end) {
                list.add(l);
                ++l;
            }
        } else {
            int l = start;
            while (l >= end) {
                list.add(l);
                --l;
            }
        }
        return list;
    }

    public static long[] sequenceLong(long start, long end) {
        return MathUtil.collectionToLong(MathUtil.sequenceListLong(start, end));
    }

    public static double[] sequenceDouble(double start, double end) {
        return MathUtil.collectionToDouble(MathUtil.sequenceListDouble(start, end));
    }

    public static int[] sequenceInt(int start, int end) {
        return MathUtil.collectionToInt(MathUtil.sequenceListInt(start, end));
    }

    public static List<Long> randPerm(long start, long end) {
        List<Long> list = MathUtil.sequenceListLong(start, end);
        Collections.shuffle(list);
        return list;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 instanceof Number || o2 instanceof Number) {
            return MathUtil.getDouble(o1) == MathUtil.getDouble(o2);
        }
        if (o1 instanceof String || o2 instanceof String) {
            return UJMPFormat.getSingleLineInstance().format(o1).equals(UJMPFormat.getSingleLineInstance().format(o2));
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            return ((Boolean)o1).equals(o2);
        }
        return false;
    }

    public static double sensitivity(double tp, double fn) {
        double r = tp / (tp + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double specificity(double tn, double fp) {
        double r = tn / (tn + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double positivePredictiveValue(double tp, double fp) {
        double r = tp / (tp + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double negativePredictiveValue(double tn, double fn) {
        double r = tn / (tn + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double falsePositiveRate(double fp, double tn) {
        double r = fp / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double falseNegativeRate(double fn, double tp) {
        double r = fn / (fn + tp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double recall(double tp, double fn) {
        double r = tp / (tp + fn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double precision(double tp, double fp) {
        double r = tp / (tp + fp);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double fallout(double tn, double fp) {
        double r = tn / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double trueNegativeRate(double tn, double fp) {
        double r = tn / (fp + tn);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double f1Measure(double precision, double recall) {
        double r = 2.0 * precision * recall / (precision + recall);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static double fBetaMeasure(double beta, double precision, double recall) {
        double r = (1.0 + beta * beta) * precision * recall / (beta * beta * precision + recall);
        return MathUtil.isNaNOrInfinite(r) ? 0.0 : r;
    }

    public static Object getPreferredObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o instanceof String) {
            Double d = MathUtil.getDouble(o);
            if (MathUtil.isNaNOrInfinite(d)) {
                return o;
            }
            return d;
        }
        return o;
    }

    public static boolean getBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue() != 0.0;
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).booleanValue();
        }
        if (o instanceof String) {
            try {
                return Boolean.parseBoolean((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static byte getByte(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Byte) {
            return (Byte)o;
        }
        if (o instanceof Number) {
            return ((Number)o).byteValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).byteValue();
        }
        if (o instanceof String) {
            try {
                return Byte.parseByte((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static BigInteger getBigInteger(Object o) {
        if (o == null) {
            return BigInteger.ZERO;
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Number) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).bigIntegerValue();
        }
        if (o instanceof String) {
            return new BigInteger((String)o);
        }
        return BigInteger.ZERO;
    }

    public static BigDecimal getBigDecimal(Object o) {
        if (o == null) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Number) {
            double val = ((Number)o).doubleValue();
            return MathUtil.isNaNOrInfinite(val) ? null : BigDecimal.valueOf(val);
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).bigDecimalValue();
        }
        if (o instanceof String) {
            try {
                return new BigDecimal((String)o);
            }
            catch (Exception e) {
                return BigDecimal.ZERO;
            }
        }
        return BigDecimal.ZERO;
    }

    public static char getChar(Object o) {
        if (o == null) {
            return '\u0000';
        }
        if (o instanceof Character) {
            return ((Character)o).charValue();
        }
        if (o instanceof Number) {
            return (char)((Number)o).byteValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).charValue();
        }
        if (o instanceof String) {
            try {
                return (char)Byte.parseByte((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return '\u0000';
    }

    public static float getFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).floatValue();
        }
        if (o instanceof String) {
            try {
                return Float.parseFloat((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0.0f;
    }

    public static Object getObject(Object o) {
        Matrix m;
        if (o == null) {
            return null;
        }
        if (o instanceof Matrix && (m = (Matrix)o).getValueCount() == 1L) {
            return m.getAsObject(0L, 0L);
        }
        return o;
    }

    public static int getInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).intValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long getLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static short getShort(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Short) {
            return (Short)o;
        }
        if (o instanceof Number) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).shortValue();
        }
        if (o instanceof String) {
            try {
                return Short.parseShort((String)o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static int[] toIntArray(long ... coordinates) {
        int[] result = new int[coordinates.length];
        int i = coordinates.length;
        while (--i != -1) {
            result[i] = (int)coordinates[i];
        }
        return result;
    }

    public static long[] toLongArray(int ... coordinates) {
        long[] result = new long[coordinates.length];
        int i = coordinates.length;
        while (--i != -1) {
            result[i] = coordinates[i];
        }
        return result;
    }

    public static boolean isNull(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof Number && ((Number)value).doubleValue() == 0.0;
    }

    public static double norminv(double p, double mu, double sigma) {
        double val;
        if (sigma <= 0.0) {
            return Double.NaN;
        }
        if (MathUtil.isNaNOrInfinite(p)) {
            return Double.NaN;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        double p_ = p;
        double q = p_ - 0.5;
        if (Math.abs(q) <= 0.425) {
            double r = 0.180625 - q * q;
            val = q * (((((((r * 2509.0809287301227 + 33430.57558358813) * r + 67265.7709270087) * r + 45921.95393154987) * r + 13731.69376550946) * r + 1971.5909503065513) * r + 133.14166789178438) * r + 3.3871328727963665) / (((((((r * 5226.495278852854 + 28729.085735721943) * r + 39307.89580009271) * r + 21213.794301586597) * r + 5394.196021424751) * r + 687.1870074920579) * r + 42.31333070160091) * r + 1.0);
        } else {
            double r = q > 0.0 ? 1.0 - p : p_;
            r = Math.sqrt(-Math.log(r));
            val = r <= 5.0 ? ((((((((r += -1.6) * 7.745450142783414E-4 + 0.022723844989269184) * r + 0.2417807251774506) * r + 1.2704582524523684) * r + 3.6478483247632045) * r + 5.769497221460691) * r + 4.630337846156546) * r + 1.4234371107496835) / (((((((r * 1.0507500716444169E-9 + 5.475938084995345E-4) * r + 0.015198666563616457) * r + 0.14810397642748008) * r + 0.6897673349851) * r + 1.6763848301838038) * r + 2.053191626637759) * r + 1.0) : ((((((((r += -5.0) * 2.0103343992922881E-7 + 2.7115555687434876E-5) * r + 0.0012426609473880784) * r + 0.026532189526576124) * r + 0.29656057182850487) * r + 1.7848265399172913) * r + 5.463784911164114) * r + 6.657904643501103) / (((((((r * 2.0442631033899397E-15 + 1.421511758316446E-7) * r + 1.8463183175100548E-5) * r + 7.868691311456133E-4) * r + 0.014875361290850615) * r + 0.1369298809227358) * r + 0.599832206555888) * r + 1.0);
            if (q < 0.0) {
                val = -val;
            }
        }
        return mu + sigma * val;
    }

    public static double f1measure(double tp, double tn, double fp, double fn) {
        double precision = MathUtil.precision(tp, fp);
        double recall = MathUtil.recall(tp, fn);
        return MathUtil.f1Measure(precision, recall);
    }

    public static final long factorial(int n) {
        long r = 1L;
        int i = 2;
        while (i <= n) {
            r *= (long)i;
            ++i;
        }
        return r;
    }

    public static final BigInteger factorialBig(int n) {
        BigInteger r = BigInteger.ONE;
        int i = 2;
        while (i <= n) {
            r = r.multiply(BigInteger.valueOf(i));
            ++i;
        }
        return r;
    }

    public static final long binomialCoefficient(int n, int k) {
        if (k > n || k < 0) {
            return 0L;
        }
        return MathUtil.factorial(n) / MathUtil.factorial(k) / MathUtil.factorial(n - k);
    }

    public static final BigInteger binomialCoefficientBig(int n, int k) {
        if (k > n || k < 0) {
            return BigInteger.ZERO;
        }
        return MathUtil.factorialBig(n).divide(MathUtil.factorialBig(k)).divide(MathUtil.factorialBig(n - k));
    }

    public static final boolean greater(BigInteger i1, BigInteger i2) {
        return i1.subtract(i2).signum() > 0;
    }

    public static final boolean smaller(BigInteger i1, BigInteger i2) {
        return i1.subtract(i2).signum() < 0;
    }

    public static int max(int[] values) {
        int max = -2147483647;
        int i = values.length - 1;
        while (i != -1) {
            max = values[i] > max ? values[i] : max;
            --i;
        }
        return max;
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        int i = values.length - 1;
        while (i != -1) {
            min = values[i] < min ? values[i] : min;
            --i;
        }
        return min;
    }

    public static final BigDecimal plus(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.add(v2, MathUtil.getDefaultMathContext());
        }
        return null;
    }

    public static final BigDecimal minus(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.subtract(v2, MathUtil.getDefaultMathContext());
        }
        return null;
    }

    public static final BigDecimal times(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.multiply(v2, MathUtil.getDefaultMathContext());
        }
        return null;
    }

    public static final BigDecimal divide(BigDecimal v1, BigDecimal v2) {
        if (v1 != null && v2 != null) {
            return v1.divide(v2, MathUtil.getDefaultMathContext());
        }
        return null;
    }
}

