/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.FileFormat;

public class Octave {
    public static String[] SEARCH = new String[0];
    public static final int POLLINTERVAL = 50;
    public static final int MAXPOLLS = 10;
    private BufferedReader input = null;
    private BufferedWriter output = null;
    private BufferedReader error = null;
    private Process octaveProcess = null;
    private boolean running = false;
    private static Octave octave;
    private static String pathToOctave;

    static {
        try {
            SEARCH = new String[]{System.getProperty("Octave"), "/usr/bin/octave", "/opt/octave/bin/octave"};
        }
        catch (Exception exception) {
            // empty catch block
        }
        octave = null;
        pathToOctave = null;
    }

    public static synchronized Octave getInstance() throws Exception {
        if (octave == null) {
            octave = Octave.getInstance(Octave.findOctave());
        }
        return octave;
    }

    public static synchronized Octave getInstance(String pathToOctave) throws Exception {
        if (octave == null) {
            octave = new Octave(pathToOctave);
        }
        return octave;
    }

    private Octave(String pathToOctave) throws Exception {
        this.octaveProcess = Runtime.getRuntime().exec(pathToOctave);
        this.output = new BufferedWriter(new OutputStreamWriter(this.octaveProcess.getOutputStream()));
        this.input = new BufferedReader(new InputStreamReader(this.octaveProcess.getInputStream()));
        this.error = new BufferedReader(new InputStreamReader(this.octaveProcess.getErrorStream()));
        String startMessage = this.getFromOctave();
        if (startMessage != null && startMessage.length() > 0) {
            this.running = true;
            return;
        }
        throw new Exception("could not start Octave");
    }

    private synchronized String getFromOctave() throws Exception {
        boolean colonSeen = false;
        boolean numberSeen = false;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 10) {
            if (this.input.ready()) break;
            Thread.sleep(50L);
            ++i;
        }
        while (this.input.ready()) {
            char c = (char)this.input.read();
            sb.append(c);
            if (numberSeen) {
                if (c == '>') {
                    return sb.toString();
                }
                colonSeen = false;
                numberSeen = false;
                continue;
            }
            if (colonSeen) {
                if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9') {
                    numberSeen = true;
                    continue;
                }
                colonSeen = false;
                numberSeen = false;
                continue;
            }
            if (c != ':') continue;
            colonSeen = true;
        }
        return sb.toString();
    }

    public String execute(String command) throws Exception {
        this.sendToOctave(command);
        return this.getFromOctave();
    }

    public synchronized void shutdown() throws Exception {
        this.sendToOctave("exit");
        this.octaveProcess.waitFor();
        this.output.close();
        this.input.close();
    }

    private synchronized void sendToOctave(String command) throws Exception {
        if (!command.endsWith("\n")) {
            command = String.valueOf(command) + "\n";
        }
        this.output.write(command, 0, command.length());
        this.output.flush();
    }

    public void setMatrix(String label, Matrix matrix) throws Exception {
        this.execute(String.valueOf(label) + "=" + matrix.exportToString(FileFormat.M, new Object[0]));
    }

    private static String findOctave() {
        if (pathToOctave == null) {
            File file = null;
            String[] stringArray = SEARCH;
            int n = SEARCH.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && (file = new File(s)).exists()) {
                    pathToOctave = file.getAbsolutePath();
                    return pathToOctave;
                }
                ++n2;
            }
        }
        return pathToOctave;
    }

    public Matrix getMatrix(String label) throws Exception {
        try {
            String rawRows = this.execute("fprintf(1,'%d\\n',size(" + label + ",1));");
            int rows = Integer.parseInt(rawRows.trim());
            String rawCols = this.execute("fprintf(1,'%d\\n',size(" + label + ",2));");
            int cols = Integer.parseInt(rawCols.trim());
            String rawText = this.execute("fprintf(1,'%55.55f\\n'," + label + ")");
            String[] rawValues = rawText.split("\n");
            Matrix matrix = MatrixFactory.zeros(rows, cols);
            int i = 0;
            int c = 0;
            while (c < cols) {
                int r = 0;
                while (r < rows) {
                    matrix.setAsDouble(Double.parseDouble(rawValues[i++]), r, c);
                    ++r;
                }
                ++c;
            }
            return matrix;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isAvailable() {
        return Octave.findOctave() != null;
    }

    public void plot(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("plot(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void loglog(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("loglog(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void semilogx(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("semilogx(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void semilogy(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("semilogy(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void bar(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("bar(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void stairs(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("stairs(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void hist(Matrix matrix, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix", matrix);
        this.execute("figure;");
        this.execute("hist(ujmpmatrix" + Octave.toString(format) + ");");
    }

    public void plot(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("plot(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void loglog(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("loglog(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void semilogx(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("semilogx(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void semilogy(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("semilogy(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void bar(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("bar(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void stairs(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("stairs(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void hist(Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("hist(ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void polar(Matrix theta, Matrix rho, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_theta", theta);
        this.setMatrix("ujmpmatrix_rho", rho);
        this.execute("figure;");
        this.execute("hist(ujmpmatrix_theta,ujmpmatrix_rho" + Octave.toString(format) + ");");
    }

    public void contour(Matrix z, Matrix n, Matrix x, Matrix y, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_z", z);
        this.setMatrix("ujmpmatrix_n", n);
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.execute("figure;");
        this.execute("contour(ujmpmatrix_z,ujmpmatrix_n,ujmpmatrix_x,ujmpmatrix_y" + Octave.toString(format) + ");");
    }

    public void mesh(Matrix x, Matrix y, Matrix z, String ... format) throws Exception {
        this.setMatrix("ujmpmatrix_x", x);
        this.setMatrix("ujmpmatrix_y", y);
        this.setMatrix("ujmpmatrix_z", z);
        this.execute("figure;");
        this.execute("mesh(ujmpmatrix_x,ujmpmatrix_y,ujmpmatrix_z" + Octave.toString(format) + ");");
    }

    public static String toString(String[] strings) {
        if (strings.length != 0) {
            return ",'" + strings[0] + "'";
        }
        return "";
    }
}

