/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.ujmp.core.Matrix;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtil {
    private static final NumberFormat DefaultNF = NumberFormat.getNumberInstance(Locale.US);
    public static final String BRACKETS = "[\\[\\]\\(\\)\\{\\}]";
    public static final String SEMICOLONORNEWLINE = "\\s*[;\\n]\\s*";
    public static final String COLONORSPACES = "[,\\s*]";

    static {
        DefaultNF.setMinimumFractionDigits(4);
        DefaultNF.setMaximumFractionDigits(4);
    }

    public static final String stripTags(String string) {
        return Pattern.compile("\\<[^\\>]*\\>", 40).matcher(string).replaceAll("");
    }

    public static final String format(String s) {
        return s == null ? "" : s;
    }

    public static final String format(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Matrix) {
            if (((Matrix)o).isScalar()) {
                return StringUtil.format(((Matrix)o).getAsObject(0L, 0L));
            }
            return "[Matrix]";
        }
        if (o instanceof Number) {
            return StringUtil.format((Number)o);
        }
        return o.toString();
    }

    public static final String convert(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Matrix) {
            return ((Matrix)o).stringValue();
        }
        if (o instanceof Number) {
            return "" + ((Number)o).doubleValue();
        }
        return o.toString();
    }

    public static final String format(Double value) {
        if (value == null) {
            return "";
        }
        if (Double.isNaN(value)) {
            return "NaN";
        }
        if (Double.POSITIVE_INFINITY == value) {
            return "Inf";
        }
        if (Double.NEGATIVE_INFINITY == value) {
            return "-Inf";
        }
        return DefaultNF.format(value);
    }

    public static final String format(Number value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Double) {
            return StringUtil.format((Double)value);
        }
        return DefaultNF.format(value);
    }

    public void setDefaultMaximumFractionDigits(int n) {
        DefaultNF.setMaximumFractionDigits(n);
    }

    public void setDefaultMinimumFractionDigits(int n) {
        DefaultNF.setMinimumFractionDigits(n);
    }

    public static final String deleteChar(String s, char ch) {
        return StringUtil.deleteChar(s, ch, 0);
    }

    public static final String deleteChar(String s, char ch, int startIndex) {
        int i = s.indexOf(ch, startIndex);
        if (i == -1) {
            return s;
        }
        if (i == 0) {
            s = s.substring(1);
            return StringUtil.deleteChar(s, ch, 0);
        }
        if (i == s.length() - 1) {
            s = s.substring(0, s.length() - 1);
            return s;
        }
        new String();
        s = String.valueOf(s.substring(0, i)) + s.substring(i + 1);
        return StringUtil.deleteChar(s, ch, i);
    }

    public static long[][] parseSelection(String selectionString, long[] size) {
        if (selectionString.contains(";")) {
            return StringUtil.parseSelectionSemicolon(selectionString, size);
        }
        return StringUtil.parseSelectionComma(selectionString, size);
    }

    private static long[][] parseSelectionComma(String selectionString, long[] size) {
        throw new MatrixException("Matlab style is not supported yet. Please use a semicolon (;) to separate rows and columns");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long[][] parseSelectionSemicolon(String selectionString, long[] size) {
        String[] fields = selectionString.replaceAll(BRACKETS, "").split(";");
        long[][] selection = new long[fields.length][];
        int i = 0;
        while (i < fields.length) {
            String dimension = fields[i].trim();
            if (dimension.contains("*")) {
                selection[i] = MathUtil.sequenceLong(0L, size[i] - 1L);
            } else {
                ArrayList<Long> list = new ArrayList<Long>();
                String[] dimselections = dimension.split("\\D*[ \\s,]\\D*");
                int j = 0;
                while (j < dimselections.length) {
                    String dimsel = dimselections[j];
                    if (dimsel.contains(":") || dimsel.contains("-")) {
                        String[] range = dimsel.split("[:-]");
                        if (range.length == 0) {
                            list.addAll(MathUtil.sequenceListLong(0L, size[i] - 1L));
                        } else {
                            if (range.length != 2) throw new MatrixException("Selection not supported: " + dimsel);
                            String startS = range[0];
                            String endS = range[1];
                            long start = Long.parseLong(startS.replaceAll("\\D", ""));
                            long end = Long.parseLong(endS.replaceAll("\\D", ""));
                            if (end > size[j]) {
                                throw new MatrixException("Selection is bigger than size");
                            }
                            list.addAll(MathUtil.sequenceListLong(start, end));
                        }
                    } else if ((dimsel = dimsel.replaceAll("\\D", "")).length() > 0) {
                        list.add(Long.parseLong(dimsel));
                    }
                    ++j;
                }
                selection[i] = MathUtil.collectionToLong(list);
            }
            ++i;
        }
        return selection;
    }

    public static String duration(long time) {
        StringBuilder s = new StringBuilder();
        int days = (int)(time / 86400000L);
        int hours = (int)((time %= 86400000L) / 3600000L);
        int minutes = (int)((time %= 3600000L) / 60000L);
        int seconds = (int)((time %= 60000L) / 1000L);
        if (days > 0) {
            s.append(String.valueOf(days) + "d");
        }
        if (hours > 0) {
            s.append(String.valueOf(hours) + "h");
        }
        if (minutes > 0) {
            s.append(String.valueOf(minutes) + "m");
        }
        s.append(String.valueOf(seconds) + "s");
        return s.toString();
    }

    public static String getAllAsString(Collection<Matrix> collection) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        for (Matrix m : collection) {
            if (m != null && !m.isEmpty()) {
                s.append(StringUtil.format(m.stringValue()));
            }
            if (i < collection.size() - 1) {
                s.append(", ");
            }
            ++i;
        }
        return s.toString();
    }

    public static String deleteChars(String s, Set<Character> ignoredChars, char replacement) {
        char[] result = new char[s.length()];
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            result[i] = !ignoredChars.contains(Character.valueOf(c)) ? c : replacement;
            ++i;
        }
        return new String(result);
    }

    public static String retainChars(String s, Set<Character> allowedChars, char replacement) {
        char[] result = new char[s.length()];
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            result[i] = allowedChars.contains(Character.valueOf(c)) ? c : replacement;
            ++i;
        }
        return new String(result);
    }

    public static String toString(Matrix m, Object ... parameters) {
        int width = 10;
        long maxRows = UJMPSettings.getMaxRowsToPrint();
        long maxColumns = UJMPSettings.getMaxColumnsToPrint();
        NumberFormat nf = DefaultNF;
        StringBuilder s = new StringBuilder();
        String EOL = System.getProperty("line.separator");
        long rowCount = m.getRowCount();
        long columnCount = m.getColumnCount();
        int row = 0;
        while ((long)row < rowCount && (long)row < maxRows) {
            int col = 0;
            while ((long)col < columnCount && (long)col < maxColumns) {
                Object o = m.getAsObject(row, col);
                String v = StringUtil.format(o);
                v = StringUtil.pad(v, width);
                s.append(v);
                ++col;
            }
            s.append(EOL);
            ++row;
        }
        if (rowCount == 0L || columnCount == 0L) {
            s.append("[" + rowCount + "x" + columnCount + "]" + EOL);
        } else if (rowCount > UJMPSettings.getMaxRowsToPrint() || columnCount > UJMPSettings.getMaxColumnsToPrint()) {
            s.append("[...]");
        }
        return s.toString();
    }

    public static final String pad(String s, int length) {
        StringBuilder r = new StringBuilder(length -= s.length());
        int i = 0;
        while (i < length) {
            r.append(" ");
            ++i;
        }
        r.append(s);
        return r.toString();
    }
}

