/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

import java.math.MathContext;
import java.util.Locale;

public abstract class UJMPSettings {
    private static double tolerance = 1.0E-12;
    private static int numberOfThreads = 1;
    private static MathContext mathContext = MathContext.DECIMAL128;
    private static long maxRowsToPrint = 100L;
    private static long maxColumnsToPrint = 100L;
    private static long maxToolTipRows = 10L;
    private static long maxToolTipCols = 10L;

    static {
        try {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            UJMPSettings.setLocale(Locale.US);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static MathContext getDefaultMathContext() {
        return mathContext;
    }

    public static void setDefaultMathContext(MathContext mc) {
        mathContext = mc;
    }

    public static void initialize() {
        try {
            System.setProperty("file.encoding", "UTF-8");
            System.setProperty("sun.jnu.encoding", "UTF-8");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getNumberOfThreads() {
        return numberOfThreads;
    }

    public static void setNumberOfThreads(int numberOfThreads) {
        UJMPSettings.numberOfThreads = numberOfThreads;
    }

    public static double getTolerance() {
        return tolerance;
    }

    public static void setTolerance(double tolerance) {
        UJMPSettings.tolerance = tolerance;
    }

    public static long getMaxColumnsToPrint() {
        return maxColumnsToPrint;
    }

    public static void setMaxColumnsToPrint(long maxColumnsToPrint) {
        UJMPSettings.maxColumnsToPrint = maxColumnsToPrint;
    }

    public static long getMaxRowsToPrint() {
        return maxRowsToPrint;
    }

    public static void setMaxRowsToPrint(long maxRowsToPrint) {
        UJMPSettings.maxRowsToPrint = maxRowsToPrint;
    }

    public static long getMaxToolTipCols() {
        return maxToolTipCols;
    }

    public static void setMaxToolTipCols(long maxToolTipCols) {
        UJMPSettings.maxToolTipCols = maxToolTipCols;
    }

    public static long getMaxToolTipRows() {
        return maxToolTipRows;
    }

    public static void setMaxToolTipRows(long maxToolTipRows) {
        UJMPSettings.maxToolTipRows = maxToolTipRows;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    public static void setLocale(Locale locale) {
        Locale.setDefault(locale);
    }
}

