/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util.matrices;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.stringmatrix.impl.DefaultDenseStringMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatrixLibraries
extends DefaultDenseStringMatrix2D {
    private static final long serialVersionUID = -2575195318248762416L;
    private static final int LABELCOLUMN = 0;
    private static final int VERSION = 1;
    private static final int DATE = 2;
    private static final int LICENCE = 3;
    private static final int JAVA14 = 4;
    private static final int JAVA5 = 5;
    private static final int JAVA6 = 6;
    private static final int MULTITHREADED = 7;
    private static final int INPLACE = 8;
    private static final int CACHEDRESULTS = 9;
    private static final int DENSE = 10;
    private static final int SPARSE = 11;
    private static final int COMPLEX = 12;
    private static final int DOUBLE = 13;
    private static final int FLOAT = 14;
    private static final int BIGDECIMAL = 15;
    private static final int D2 = 16;
    private static final int D3 = 17;
    private static final int D4 = 18;
    private static final int D4PLUS = 19;
    private static final int TRANSPOSE = 20;
    private static final int SCALE = 21;
    private static final int PLUSMINUS = 22;
    private static final int INV = 23;
    private static final int SOLVE = 24;
    private static final int LU = 25;
    private static final int QR = 26;
    private static final int SVD = 27;
    private static final int CHOL = 28;
    private static final int EIG = 29;
    private static final int LABELROW = 0;
    private static final int ARRAY4J = 1;
    private static final int COLT = 2;
    private static final int COMMONSMATH = 3;
    private static final int EJML = 4;
    private static final int JAMA = 5;
    private static final int JAMPACK = 6;
    private static final int JLINALG = 7;
    private static final int JMATHARRAY = 8;
    private static final int JMATRICES = 9;
    private static final int JSCI = 10;
    private static final int JSCIENCE = 11;
    private static final int MANTISSA = 12;
    private static final int MTJ = 13;
    private static final int OJALGO = 14;
    private static final int ORBITAL = 15;
    private static final int OWLPACK = 16;
    private static final int PARALLELCOLT = 17;
    private static final int SST = 18;
    private static final int UJMP = 19;
    private static final int VECMATH = 20;
    private List<String> footnotes = new ArrayList<String>();
    private MatrixLibrariesFormat format = MatrixLibrariesFormat.DEFAULT;

    public MatrixLibraries() {
        this(MatrixLibrariesFormat.DEFAULT);
    }

    public MatrixLibraries(MatrixLibrariesFormat format) {
        super(30L, 21L);
        this.format = format;
        this.setAsString(this.turn("Array4J"), 0L, 1L);
        this.setAsString(this.turn("Colt"), 0L, 2L);
        this.setAsString(this.turn("commons-math"), 0L, 3L);
        this.setAsString(this.turn("EJML"), 0L, 4L);
        this.setAsString(this.turn("JAMA"), 0L, 5L);
        this.setAsString(this.turn("Jampack"), 0L, 6L);
        this.setAsString(this.turn("JLinAlg"), 0L, 7L);
        this.setAsString(this.turn("JMathArray"), 0L, 8L);
        this.setAsString(this.turn("JMatrices"), 0L, 9L);
        this.setAsString(this.turn("JSci"), 0L, 10L);
        this.setAsString(this.turn("JScience"), 0L, 11L);
        this.setAsString(this.turn("Mantissa"), 0L, 12L);
        this.setAsString(this.turn("MTJ"), 0L, 13L);
        this.setAsString(this.turn("ojAlgo"), 0L, 14L);
        this.setAsString(this.turn("Orbital"), 0L, 15L);
        this.setAsString(this.turn("OWLPack"), 0L, 16L);
        this.setAsString(this.turn("Parallel Colt"), 0L, 17L);
        this.setAsString(this.turn("SST"), 0L, 18L);
        this.setAsString(this.turn("UJMP"), 0L, 19L);
        this.setAsString(this.turn("vecmath"), 0L, 20L);
        this.setAsString("version", 1L, 0L);
        this.setAsString("release", 2L, 0L);
        this.setAsString("licence", 3L, 0L);
        this.setAsString("Java 1.4", 4L, 0L);
        this.setAsString("Java 5", 5L, 0L);
        this.setAsString("Java 6", 6L, 0L);
        this.setAsString("multithreaded", 7L, 0L);
        this.setAsString("in-place ops", 8L, 0L);
        this.setAsString("cached results", 9L, 0L);
        this.setAsString("dense", 10L, 0L);
        this.setAsString("sparse", 11L, 0L);
        this.setAsString("complex", 12L, 0L);
        this.setAsString("double", 13L, 0L);
        this.setAsString("float", 14L, 0L);
        this.setAsString("BigDecimal", 15L, 0L);
        this.setAsString("2D", 16L, 0L);
        this.setAsString("3D", 17L, 0L);
        this.setAsString("4D", 18L, 0L);
        this.setAsString("$>$4D", 19L, 0L);
        this.setAsString("transpose", 20L, 0L);
        this.setAsString("scale", 21L, 0L);
        this.setAsString("plus/minus", 22L, 0L);
        this.setAsString("inverse", 23L, 0L);
        this.setAsString("solve", 24L, 0L);
        this.setAsString("SVD", 27L, 0L);
        this.setAsString("LU", 25L, 0L);
        this.setAsString("QR", 26L, 0L);
        this.setAsString("Cholesky", 28L, 0L);
        this.setAsString("Eigen", 29L, 0L);
        this.setAsString("0.2.4", 1L, 19L);
        this.setAsString(this.small("2010"), 2L, 19L);
        this.setAsString(this.small("LGPL"), 3L, 19L);
        this.setAsString(this.no(), 4L, 19L);
        this.setAsString(this.yes(), 5L, 19L);
        this.setAsString(this.yes(), 6L, 19L);
        this.setAsString(this.both(), 7L, 19L);
        this.setAsString(this.yes(), 8L, 19L);
        this.setAsString(this.no(), 9L, 19L);
        this.setAsString(this.yes(), 10L, 19L);
        this.setAsString(this.yes(), 11L, 19L);
        this.setAsString(this.no(), 12L, 19L);
        this.setAsString(this.yes(), 13L, 19L);
        this.setAsString(this.yes(), 14L, 19L);
        this.setAsString(this.yes(), 15L, 19L);
        this.setAsString(this.yes(), 16L, 19L);
        this.setAsString(this.yes(), 17L, 19L);
        this.setAsString(this.yes(), 18L, 19L);
        this.setAsString(this.yes(), 19L, 19L);
        this.setAsString(this.yes(), 20L, 19L);
        this.setAsString(this.yes(), 21L, 19L);
        this.setAsString(this.yes(), 22L, 19L);
        this.setAsString(this.yes(), 23L, 19L);
        this.setAsString(this.squareTall(), 24L, 19L);
        this.setAsString(this.yes(), 28L, 19L);
        this.setAsString(this.yes(), 29L, 19L);
        this.setAsString(this.all(), 25L, 19L);
        this.setAsString(this.squareTall(), 26L, 19L);
        this.setAsString(this.all(), 27L, 19L);
        this.setAsString(this.small("SVN"), 1L, 1L);
        this.setAsString(this.small("2008"), 2L, 1L);
        this.setAsString(this.small("BSD"), 3L, 1L);
        this.setAsString(this.no(), 4L, 1L);
        this.setAsString(this.no(), 5L, 1L);
        this.setAsString(this.yes(), 6L, 1L);
        this.setAsString(this.unknown(), 7L, 1L);
        this.setAsString(this.unknown(), 8L, 1L);
        this.setAsString(this.yes(), 10L, 1L);
        this.setAsString(String.valueOf(this.no()) + this.footnote("i", "interface only, no implementation"), 11L, 1L);
        this.setAsString(String.valueOf(this.no()) + this.footnote("i", "interface only, no implementation"), 12L, 1L);
        this.setAsString(String.valueOf(this.no()) + this.footnote("i", "interface only, no implementation"), 13L, 1L);
        this.setAsString(this.yes(), 14L, 1L);
        this.setAsString(this.no(), 15L, 1L);
        this.setAsString(this.no(), 7L, 1L);
        this.setAsString(this.yes(), 8L, 1L);
        this.setAsString(this.yes(), 16L, 1L);
        this.setAsString(this.no(), 17L, 1L);
        this.setAsString(this.no(), 18L, 1L);
        this.setAsString(this.no(), 19L, 1L);
        this.setAsString(this.no(), 24L, 1L);
        this.setAsString(this.no(), 23L, 1L);
        this.setAsString(this.no(), 27L, 1L);
        this.setAsString(this.no(), 26L, 1L);
        this.setAsString(this.no(), 25L, 1L);
        this.setAsString(this.no(), 29L, 1L);
        this.setAsString(this.no(), 28L, 1L);
        this.setAsString(this.small("1.2.0"), 1L, 2L);
        this.setAsString(this.small("2004"), 2L, 2L);
        this.setAsString(this.small("BSD"), 3L, 2L);
        this.setAsString(this.yes(), 4L, 2L);
        this.setAsString(this.yes(), 5L, 2L);
        this.setAsString(this.yes(), 6L, 2L);
        this.setAsString(this.no(), 7L, 2L);
        this.setAsString(this.yes(), 8L, 2L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 20L, 2L);
        this.setAsString(this.yes(), 21L, 2L);
        this.setAsString(this.yes(), 22L, 2L);
        this.setAsString(this.yes(), 10L, 2L);
        this.setAsString(this.yes(), 11L, 2L);
        this.setAsString(this.no(), 12L, 2L);
        this.setAsString(this.yes(), 13L, 2L);
        this.setAsString(this.no(), 14L, 2L);
        this.setAsString(this.no(), 15L, 2L);
        this.setAsString(this.yes(), 16L, 2L);
        this.setAsString(this.yes(), 17L, 2L);
        this.setAsString(this.no(), 18L, 2L);
        this.setAsString(this.no(), 19L, 2L);
        this.setAsString(this.yes(), 23L, 2L);
        this.setAsString(this.squareTall(), 24L, 2L);
        this.setAsString(this.squareTall(), 27L, 2L);
        this.setAsString(this.squareTall(), 25L, 2L);
        this.setAsString(this.all(), 26L, 2L);
        this.setAsString(this.yes(), 29L, 2L);
        this.setAsString(this.yes(), 28L, 2L);
        this.setAsString(this.small("2.0"), 1L, 3L);
        this.setAsString(this.small("2009"), 2L, 3L);
        this.setAsString(this.small("Apache"), 3L, 3L);
        this.setAsString(this.no(), 4L, 3L);
        this.setAsString(this.yes(), 5L, 3L);
        this.setAsString(this.yes(), 6L, 3L);
        this.setAsString(this.no(), 7L, 3L);
        this.setAsString(this.no(), 8L, 3L);
        this.setAsString(this.yes(), 20L, 3L);
        this.setAsString(this.yes(), 21L, 3L);
        this.setAsString(this.yes(), 22L, 3L);
        this.setAsString(this.yes(), 10L, 3L);
        this.setAsString(this.yes(), 11L, 3L);
        this.setAsString(this.yes(), 12L, 3L);
        this.setAsString(this.yes(), 13L, 3L);
        this.setAsString(this.no(), 14L, 3L);
        this.setAsString(this.yes(), 15L, 3L);
        this.setAsString(this.yes(), 16L, 3L);
        this.setAsString(this.no(), 17L, 3L);
        this.setAsString(this.no(), 18L, 3L);
        this.setAsString(this.no(), 19L, 3L);
        this.setAsString(this.yes(), 23L, 3L);
        this.setAsString(this.squareTall(), 24L, 3L);
        this.setAsString(String.valueOf(this.all()) + this.footnote("e", "error in implementation"), 27L, 3L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("n", "non-singular matrices only"), 25L, 3L);
        this.setAsString(this.all(), 26L, 3L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only"), 29L, 3L);
        this.setAsString(this.yes(), 28L, 3L);
        this.setAsString(this.small("0.9"), 1L, 4L);
        this.setAsString(this.small("2010"), 2L, 4L);
        this.setAsString(this.small("LGPL"), 3L, 4L);
        this.setAsString(this.no(), 4L, 4L);
        this.setAsString(this.no(), 5L, 4L);
        this.setAsString(this.yes(), 6L, 4L);
        this.setAsString(this.no(), 7L, 4L);
        this.setAsString(this.no(), 9L, 4L);
        this.setAsString(this.yes(), 8L, 4L);
        this.setAsString(this.yes(), 10L, 4L);
        this.setAsString(this.no(), 11L, 4L);
        this.setAsString(this.no(), 12L, 4L);
        this.setAsString(this.yes(), 13L, 4L);
        this.setAsString(this.no(), 14L, 4L);
        this.setAsString(this.no(), 15L, 4L);
        this.setAsString(this.yes(), 16L, 4L);
        this.setAsString(this.no(), 17L, 4L);
        this.setAsString(this.no(), 18L, 4L);
        this.setAsString(this.no(), 19L, 4L);
        this.setAsString(this.yes(), 20L, 4L);
        this.setAsString(this.yes(), 21L, 4L);
        this.setAsString(this.yes(), 22L, 4L);
        this.setAsString(this.yes(), 23L, 4L);
        this.setAsString(this.squareTall(), 24L, 4L);
        this.setAsString(this.all(), 27L, 4L);
        this.setAsString(this.all(), 25L, 4L);
        this.setAsString(this.squareTall(), 26L, 4L);
        this.setAsString(this.no(), 29L, 4L);
        this.setAsString(this.yes(), 28L, 4L);
        this.setAsString(this.small("1.0.2"), 1L, 5L);
        this.setAsString(this.small("2005"), 2L, 5L);
        this.setAsString(this.small("PD"), 3L, 5L);
        this.setAsString(this.yes(), 4L, 5L);
        this.setAsString(this.yes(), 5L, 5L);
        this.setAsString(this.yes(), 6L, 5L);
        this.setAsString(this.no(), 7L, 5L);
        this.setAsString(this.no(), 8L, 5L);
        this.setAsString(this.no(), 9L, 5L);
        this.setAsString(this.yes(), 10L, 5L);
        this.setAsString(this.no(), 11L, 5L);
        this.setAsString(this.no(), 12L, 5L);
        this.setAsString(this.yes(), 13L, 5L);
        this.setAsString(this.no(), 14L, 5L);
        this.setAsString(this.no(), 15L, 5L);
        this.setAsString(this.yes(), 16L, 5L);
        this.setAsString(this.no(), 17L, 5L);
        this.setAsString(this.no(), 18L, 5L);
        this.setAsString(this.no(), 19L, 5L);
        this.setAsString(this.yes(), 20L, 5L);
        this.setAsString(this.yes(), 21L, 5L);
        this.setAsString(this.yes(), 22L, 5L);
        this.setAsString(this.yes(), 23L, 5L);
        this.setAsString(this.squareTall(), 24L, 5L);
        this.setAsString(this.squareTall(), 27L, 5L);
        this.setAsString(this.squareTall(), 25L, 5L);
        this.setAsString(this.squareTall(), 26L, 5L);
        this.setAsString(this.yes(), 29L, 5L);
        this.setAsString(this.yes(), 28L, 5L);
        this.setAsString(this.small("?"), 1L, 6L);
        this.setAsString(this.small("1999"), 2L, 6L);
        this.setAsString(this.small("?"), 3L, 6L);
        this.setAsString(this.yes(), 4L, 6L);
        this.setAsString(this.yes(), 5L, 6L);
        this.setAsString(this.yes(), 6L, 6L);
        this.setAsString(this.unknown(), 7L, 6L);
        this.setAsString(this.unknown(), 8L, 6L);
        this.setAsString(this.yes(), 10L, 6L);
        this.setAsString(this.no(), 11L, 6L);
        this.setAsString(this.yes(), 12L, 6L);
        this.setAsString(this.yes(), 13L, 6L);
        this.setAsString(this.no(), 14L, 6L);
        this.setAsString(this.no(), 15L, 6L);
        this.setAsString(this.yes(), 16L, 6L);
        this.setAsString(this.no(), 17L, 6L);
        this.setAsString(this.no(), 18L, 6L);
        this.setAsString(this.no(), 19L, 6L);
        this.setAsString(this.yes(), 23L, 6L);
        this.setAsString(this.square(), 24L, 6L);
        this.setAsString(this.square(), 27L, 6L);
        this.setAsString(this.all(), 25L, 6L);
        this.setAsString(this.yes(), 26L, 6L);
        this.setAsString(this.yes(), 29L, 6L);
        this.setAsString(this.yes(), 28L, 6L);
        this.setAsString(this.small("0.6"), 1L, 7L);
        this.setAsString(this.small("2009"), 2L, 7L);
        this.setAsString(this.small("GPL"), 3L, 7L);
        this.setAsString(this.no(), 4L, 7L);
        this.setAsString(this.unknown(), 5L, 7L);
        this.setAsString(this.yes(), 6L, 7L);
        this.setAsString(this.unknown(), 7L, 7L);
        this.setAsString(this.unknown(), 8L, 7L);
        this.setAsString(this.yes(), 10L, 7L);
        this.setAsString(this.no(), 11L, 7L);
        this.setAsString(this.yes(), 12L, 7L);
        this.setAsString(this.yes(), 13L, 7L);
        this.setAsString(this.no(), 14L, 7L);
        this.setAsString(this.yes(), 15L, 7L);
        this.setAsString(this.yes(), 16L, 7L);
        this.setAsString(this.no(), 17L, 7L);
        this.setAsString(this.no(), 18L, 7L);
        this.setAsString(this.no(), 19L, 7L);
        this.setAsString(this.yes(), 23L, 7L);
        this.setAsString(this.no(), 27L, 7L);
        this.setAsString(this.no(), 25L, 7L);
        this.setAsString(this.no(), 26L, 7L);
        this.setAsString(this.no(), 29L, 7L);
        this.setAsString(this.no(), 28L, 7L);
        this.setAsString(this.small("?"), 1L, 8L);
        this.setAsString(this.small("2009"), 2L, 8L);
        this.setAsString(this.small("BSD"), 3L, 8L);
        this.setAsString(this.no(), 4L, 8L);
        this.setAsString(this.yes(), 5L, 8L);
        this.setAsString(this.yes(), 6L, 8L);
        this.setAsString(this.unknown(), 7L, 8L);
        this.setAsString(this.unknown(), 8L, 8L);
        this.setAsString(this.yes(), 10L, 8L);
        this.setAsString(this.no(), 11L, 8L);
        this.setAsString(this.no(), 12L, 8L);
        this.setAsString(this.yes(), 13L, 8L);
        this.setAsString(this.no(), 14L, 8L);
        this.setAsString(this.no(), 15L, 8L);
        this.setAsString(this.yes(), 16L, 8L);
        this.setAsString(this.no(), 17L, 8L);
        this.setAsString(this.no(), 18L, 8L);
        this.setAsString(this.no(), 19L, 8L);
        this.setAsString(this.yes(), 23L, 8L);
        this.setAsString(this.squareTall(), 27L, 8L);
        this.setAsString(this.squareTall(), 25L, 8L);
        this.setAsString(this.squareTall(), 26L, 8L);
        this.setAsString(this.yes(), 29L, 8L);
        this.setAsString(this.yes(), 28L, 8L);
        this.setAsString(this.small("0.6"), 1L, 9L);
        this.setAsString(this.small("2004"), 2L, 9L);
        this.setAsString(this.small("LGPL"), 3L, 9L);
        this.setAsString(this.yes(), 4L, 9L);
        this.setAsString(this.yes(), 5L, 9L);
        this.setAsString(this.yes(), 6L, 9L);
        this.setAsString(this.unknown(), 7L, 9L);
        this.setAsString(this.unknown(), 8L, 9L);
        this.setAsString(this.yes(), 10L, 9L);
        this.setAsString(this.no(), 11L, 9L);
        this.setAsString(this.yes(), 12L, 9L);
        this.setAsString(this.yes(), 13L, 9L);
        this.setAsString(this.no(), 14L, 9L);
        this.setAsString(this.yes(), 15L, 9L);
        this.setAsString(this.yes(), 16L, 9L);
        this.setAsString(this.no(), 17L, 9L);
        this.setAsString(this.no(), 18L, 9L);
        this.setAsString(this.no(), 19L, 9L);
        this.setAsString(this.yes(), 23L, 9L);
        this.setAsString(this.square(), 27L, 9L);
        this.setAsString(this.squareTall(), 25L, 9L);
        this.setAsString(this.squareTall(), 26L, 9L);
        this.setAsString(this.yes(), 29L, 9L);
        this.setAsString(this.yes(), 28L, 9L);
        this.setAsString(this.small("1.1"), 1L, 10L);
        this.setAsString(this.small("2009"), 2L, 10L);
        this.setAsString(this.small("LGPL"), 3L, 10L);
        this.setAsString(this.yes(), 4L, 10L);
        this.setAsString(this.yes(), 5L, 10L);
        this.setAsString(this.yes(), 6L, 10L);
        this.setAsString(this.unknown(), 7L, 10L);
        this.setAsString(this.unknown(), 8L, 10L);
        this.setAsString(this.yes(), 10L, 10L);
        this.setAsString(this.yes(), 11L, 10L);
        this.setAsString(this.yes(), 12L, 10L);
        this.setAsString(this.yes(), 13L, 10L);
        this.setAsString(this.no(), 14L, 10L);
        this.setAsString(this.no(), 15L, 10L);
        this.setAsString(this.yes(), 16L, 10L);
        this.setAsString(this.no(), 17L, 10L);
        this.setAsString(this.no(), 18L, 10L);
        this.setAsString(this.no(), 19L, 10L);
        this.setAsString(this.yes(), 23L, 10L);
        this.setAsString(this.square(), 27L, 10L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("e", "error in implementation"), 25L, 10L);
        this.setAsString(this.square(), 26L, 10L);
        this.setAsString(this.no(), 29L, 10L);
        this.setAsString(this.yes(), 28L, 10L);
        this.setAsString(this.small("4.3.1"), 1L, 11L);
        this.setAsString(this.small("2007"), 2L, 11L);
        this.setAsString(this.small("BSD"), 3L, 11L);
        this.setAsString(this.no(), 4L, 11L);
        this.setAsString(this.yes(), 5L, 11L);
        this.setAsString(this.yes(), 6L, 11L);
        this.setAsString(this.unknown(), 7L, 11L);
        this.setAsString(this.unknown(), 8L, 11L);
        this.setAsString(this.yes(), 10L, 11L);
        this.setAsString(this.yes(), 11L, 11L);
        this.setAsString(this.yes(), 12L, 11L);
        this.setAsString(this.yes(), 13L, 11L);
        this.setAsString(this.no(), 14L, 11L);
        this.setAsString(this.no(), 15L, 11L);
        this.setAsString(this.yes(), 16L, 11L);
        this.setAsString(this.no(), 17L, 11L);
        this.setAsString(this.no(), 18L, 11L);
        this.setAsString(this.no(), 19L, 11L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 20L, 11L);
        this.setAsString(this.yes(), 21L, 11L);
        this.setAsString(this.yes(), 22L, 11L);
        this.setAsString(this.yes(), 23L, 11L);
        this.setAsString(this.square(), 24L, 11L);
        this.setAsString(this.no(), 27L, 11L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("e", "error in implementation"), 25L, 11L);
        this.setAsString(this.no(), 26L, 11L);
        this.setAsString(this.no(), 29L, 11L);
        this.setAsString(this.no(), 28L, 11L);
        this.setAsString(this.small("7.2"), 1L, 12L);
        this.setAsString(this.small("2007"), 2L, 12L);
        this.setAsString(this.small("BSD"), 3L, 12L);
        this.setAsString(this.yes(), 4L, 12L);
        this.setAsString(this.yes(), 5L, 12L);
        this.setAsString(this.yes(), 6L, 12L);
        this.setAsString(this.unknown(), 7L, 12L);
        this.setAsString(this.unknown(), 8L, 12L);
        this.setAsString(this.yes(), 10L, 12L);
        this.setAsString(this.no(), 11L, 12L);
        this.setAsString(this.no(), 12L, 12L);
        this.setAsString(this.yes(), 13L, 12L);
        this.setAsString(this.no(), 14L, 12L);
        this.setAsString(this.no(), 15L, 12L);
        this.setAsString(this.yes(), 16L, 12L);
        this.setAsString(this.no(), 17L, 12L);
        this.setAsString(this.no(), 18L, 12L);
        this.setAsString(this.no(), 19L, 12L);
        this.setAsString(this.yes(), 23L, 12L);
        this.setAsString(this.no(), 27L, 12L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("o", "not accessible from outside"), 25L, 12L);
        this.setAsString(this.no(), 26L, 12L);
        this.setAsString(this.no(), 29L, 12L);
        this.setAsString(this.no(), 28L, 12L);
        this.setAsString(this.small("0.9.12"), 1L, 13L);
        this.setAsString(this.small("2009"), 2L, 13L);
        this.setAsString(this.small("LGPL"), 3L, 13L);
        this.setAsString(this.no(), 4L, 13L);
        this.setAsString(this.yes(), 5L, 13L);
        this.setAsString(this.yes(), 6L, 13L);
        this.setAsString(this.unknown(), 7L, 13L);
        this.setAsString(this.yes(), 8L, 13L);
        this.setAsString(this.yes(), 10L, 13L);
        this.setAsString(this.yes(), 11L, 13L);
        this.setAsString(this.no(), 12L, 13L);
        this.setAsString(this.yes(), 13L, 13L);
        this.setAsString(this.no(), 14L, 13L);
        this.setAsString(this.no(), 15L, 13L);
        this.setAsString(this.yes(), 16L, 13L);
        this.setAsString(this.no(), 17L, 13L);
        this.setAsString(this.no(), 18L, 13L);
        this.setAsString(this.no(), 19L, 13L);
        this.setAsString(this.yes(), 20L, 13L);
        this.setAsString(this.yes(), 21L, 13L);
        this.setAsString(this.yes(), 22L, 13L);
        this.setAsString(this.yes(), 23L, 13L);
        this.setAsString(this.squareTall(), 24L, 13L);
        this.setAsString(this.all(), 27L, 13L);
        this.setAsString(String.valueOf(this.all()) + this.footnote("e", "error in implementation"), 25L, 13L);
        this.setAsString(this.squareTall(), 26L, 13L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("s", "symmetric matrices only"), 29L, 13L);
        this.setAsString(this.yes(), 28L, 13L);
        this.setAsString(this.small("28.31"), 1L, 14L);
        this.setAsString(this.small("2010"), 2L, 14L);
        this.setAsString(this.small("MIT"), 3L, 14L);
        this.setAsString(this.no(), 4L, 14L);
        this.setAsString(this.yes(), 5L, 14L);
        this.setAsString(this.yes(), 6L, 14L);
        this.setAsString(this.yes(), 7L, 14L);
        this.setAsString(this.yes(), 8L, 14L);
        this.setAsString(this.no(), 9L, 14L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 20L, 14L);
        this.setAsString(this.yes(), 21L, 14L);
        this.setAsString(this.yes(), 22L, 14L);
        this.setAsString(this.yes(), 10L, 14L);
        this.setAsString(this.no(), 11L, 14L);
        this.setAsString(this.yes(), 12L, 14L);
        this.setAsString(this.yes(), 13L, 14L);
        this.setAsString(this.yes(), 14L, 14L);
        this.setAsString(this.yes(), 15L, 14L);
        this.setAsString(this.yes(), 16L, 14L);
        this.setAsString(this.no(), 17L, 14L);
        this.setAsString(this.no(), 18L, 14L);
        this.setAsString(this.no(), 19L, 14L);
        this.setAsString(this.yes(), 23L, 14L);
        this.setAsString(this.squareTall(), 24L, 14L);
        this.setAsString(this.all(), 27L, 14L);
        this.setAsString(this.all(), 25L, 14L);
        this.setAsString(this.all(), 26L, 14L);
        this.setAsString(this.yes(), 29L, 14L);
        this.setAsString(this.yes(), 28L, 14L);
        this.setAsString(this.small("1.3.0"), 1L, 15L);
        this.setAsString(this.small("2009"), 2L, 15L);
        this.setAsString(this.small("custom"), 3L, 15L);
        this.setAsString(this.yes(), 4L, 15L);
        this.setAsString(this.yes(), 5L, 15L);
        this.setAsString(this.yes(), 6L, 15L);
        this.setAsString(this.unknown(), 7L, 15L);
        this.setAsString(this.unknown(), 8L, 15L);
        this.setAsString(this.no(), 9L, 15L);
        this.setAsString(this.yes(), 10L, 15L);
        this.setAsString(this.no(), 11L, 15L);
        this.setAsString(this.yes(), 12L, 15L);
        this.setAsString(this.yes(), 13L, 15L);
        this.setAsString(this.no(), 14L, 15L);
        this.setAsString(this.no(), 15L, 15L);
        this.setAsString(this.yes(), 16L, 15L);
        this.setAsString(this.no(), 17L, 15L);
        this.setAsString(this.no(), 18L, 15L);
        this.setAsString(this.no(), 19L, 15L);
        this.setAsString(this.yes(), 23L, 15L);
        this.setAsString(this.no(), 27L, 15L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("e", "error in implementation"), 25L, 15L);
        this.setAsString(this.no(), 26L, 15L);
        this.setAsString(this.no(), 29L, 15L);
        this.setAsString(this.no(), 28L, 15L);
        this.setAsString(this.unknown(), 1L, 16L);
        this.setAsString(this.small("1999"), 2L, 16L);
        this.setAsString(this.unknown(), 3L, 16L);
        this.setAsString(this.yes(), 4L, 16L);
        this.setAsString(this.yes(), 5L, 16L);
        this.setAsString(this.yes(), 6L, 16L);
        this.setAsString(this.no(), 7L, 16L);
        this.setAsString(this.unknown(), 8L, 16L);
        this.setAsString(this.no(), 9L, 16L);
        this.setAsString(this.yes(), 10L, 16L);
        this.setAsString(this.no(), 11L, 16L);
        this.setAsString(this.yes(), 12L, 16L);
        this.setAsString(this.yes(), 13L, 16L);
        this.setAsString(this.yes(), 14L, 16L);
        this.setAsString(this.no(), 15L, 16L);
        this.setAsString(this.yes(), 16L, 16L);
        this.setAsString(this.no(), 17L, 16L);
        this.setAsString(this.no(), 18L, 16L);
        this.setAsString(this.no(), 19L, 16L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("e", "error in implementation"), 23L, 16L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("e", "error in implementation"), 27L, 16L);
        this.setAsString(this.no(), 25L, 16L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("u", "unuseable without documentation"), 26L, 16L);
        this.setAsString(this.no(), 29L, 16L);
        this.setAsString(this.no(), 28L, 16L);
        this.setAsString(this.small("0.9.2"), 1L, 17L);
        this.setAsString(this.small("2010"), 2L, 17L);
        this.setAsString(this.small("BSD"), 3L, 17L);
        this.setAsString(this.yes(), 4L, 17L);
        this.setAsString(this.yes(), 5L, 17L);
        this.setAsString(this.yes(), 6L, 17L);
        this.setAsString(this.yes(), 7L, 17L);
        this.setAsString(this.yes(), 8L, 17L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("f", "flags matrix as transposed"), 20L, 17L);
        this.setAsString(this.yes(), 21L, 17L);
        this.setAsString(this.yes(), 22L, 17L);
        this.setAsString(this.no(), 9L, 17L);
        this.setAsString(this.yes(), 10L, 17L);
        this.setAsString(this.yes(), 11L, 17L);
        this.setAsString(this.yes(), 12L, 17L);
        this.setAsString(this.yes(), 13L, 17L);
        this.setAsString(this.yes(), 14L, 17L);
        this.setAsString(this.no(), 15L, 17L);
        this.setAsString(this.yes(), 16L, 17L);
        this.setAsString(this.yes(), 17L, 17L);
        this.setAsString(this.no(), 18L, 17L);
        this.setAsString(this.no(), 19L, 17L);
        this.setAsString(this.yes(), 23L, 17L);
        this.setAsString(this.squareTall(), 24L, 17L);
        this.setAsString(this.all(), 27L, 17L);
        this.setAsString(this.squareTall(), 25L, 17L);
        this.setAsString(this.squareTall(), 26L, 17L);
        this.setAsString(this.yes(), 29L, 17L);
        this.setAsString(this.yes(), 28L, 17L);
        this.setAsString(this.small("1.10"), 1L, 18L);
        this.setAsString(this.small("2009"), 2L, 18L);
        this.setAsString(this.small("LGPL"), 3L, 18L);
        this.setAsString(this.no(), 4L, 18L);
        this.setAsString(String.valueOf(this.yes()) + this.footnote("5", "jar does not work with Java 5"), 5L, 18L);
        this.setAsString(this.yes(), 6L, 18L);
        this.setAsString(this.no(), 7L, 18L);
        this.setAsString(this.yes(), 8L, 18L);
        this.setAsString(this.yes(), 20L, 18L);
        this.setAsString(this.yes(), 21L, 18L);
        this.setAsString(this.yes(), 22L, 18L);
        this.setAsString(this.no(), 9L, 18L);
        this.setAsString(this.yes(), 10L, 18L);
        this.setAsString(this.yes(), 11L, 18L);
        this.setAsString(this.yes(), 12L, 18L);
        this.setAsString(this.yes(), 13L, 18L);
        this.setAsString(this.no(), 14L, 18L);
        this.setAsString(this.no(), 15L, 18L);
        this.setAsString(this.yes(), 16L, 18L);
        this.setAsString(this.yes(), 17L, 18L);
        this.setAsString(this.yes(), 18L, 18L);
        this.setAsString(this.yes(), 19L, 18L);
        this.setAsString(this.yes(), 23L, 18L);
        this.setAsString(this.no(), 24L, 18L);
        this.setAsString(this.all(), 27L, 18L);
        this.setAsString(this.no(), 25L, 18L);
        this.setAsString(this.no(), 26L, 18L);
        this.setAsString(this.yes(), 29L, 18L);
        this.setAsString(this.no(), 28L, 18L);
        this.setAsString(this.small("1.5.1"), 1L, 20L);
        this.setAsString(this.small("2007"), 2L, 20L);
        this.setAsString(this.small("other"), 3L, 20L);
        this.setAsString(this.no(), 4L, 20L);
        this.setAsString(this.yes(), 5L, 20L);
        this.setAsString(this.yes(), 6L, 20L);
        this.setAsString(this.no(), 7L, 20L);
        this.setAsString(this.yes(), 8L, 20L);
        this.setAsString(this.yes(), 20L, 20L);
        this.setAsString(this.no(), 21L, 20L);
        this.setAsString(this.yes(), 22L, 20L);
        this.setAsString(this.no(), 9L, 20L);
        this.setAsString(this.yes(), 10L, 20L);
        this.setAsString(this.no(), 11L, 20L);
        this.setAsString(this.no(), 12L, 20L);
        this.setAsString(this.yes(), 13L, 20L);
        this.setAsString(this.no(), 14L, 20L);
        this.setAsString(this.no(), 15L, 20L);
        this.setAsString(this.yes(), 16L, 20L);
        this.setAsString(this.no(), 17L, 20L);
        this.setAsString(this.no(), 18L, 20L);
        this.setAsString(this.no(), 19L, 20L);
        this.setAsString(this.yes(), 23L, 20L);
        this.setAsString(this.no(), 24L, 20L);
        this.setAsString(String.valueOf(this.circle()) + this.footnote("e", "error in implementation"), 27L, 20L);
        this.setAsString(String.valueOf(this.square()) + this.footnote("n", "non-singular matrices only"), 25L, 20L);
        this.setAsString(this.no(), 26L, 20L);
        this.setAsString(this.no(), 29L, 20L);
        this.setAsString(this.no(), 28L, 20L);
    }

    private String yes() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$+$}";
            }
        }
        return "yes";
    }

    private String both() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$+/-$}";
            }
        }
        return "configurable";
    }

    private String all() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$\\,\\scalebox{1.0}[0.6]{$\\square$}";
            }
        }
        return "all";
    }

    private String squareTall() {
        switch (this.format) {
            case LATEX: {
                return "\\scalebox{0.6}[1.0]{$\\square$}\\,$\\square$";
            }
        }
        return "square, tall";
    }

    private String square() {
        switch (this.format) {
            case LATEX: {
                return "$\\square$";
            }
        }
        return "square";
    }

    private String circle() {
        switch (this.format) {
            case LATEX: {
                return "$\\circ$";
            }
        }
        return "square";
    }

    private String no() {
        switch (this.format) {
            case LATEX: {
                return "\\bf{$-$}";
            }
        }
        return "yes";
    }

    private String unknown() {
        return "?";
    }

    private String turn(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\begin{turn}{90}" + text + "\\end{turn}";
            }
        }
        return "";
    }

    private String small(String text) {
        switch (this.format) {
            case LATEX: {
                return "\\small " + text;
            }
        }
        return text;
    }

    private String footnote(String footnote, String text) {
        switch (this.format) {
            case LATEX: {
                String f = "$^\\mathrm{" + footnote + "}$ " + text;
                if (!this.footnotes.contains(f)) {
                    this.footnotes.add(f);
                }
                return "$^{\\mathrm{" + footnote + "}}$";
            }
        }
        String f = String.valueOf(footnote) + " " + text;
        if (!this.footnotes.contains(f)) {
            this.footnotes.add(f);
        }
        return text;
    }

    public List<String> getFootnotes() {
        return this.footnotes;
    }

    public static void main(String[] args) throws Exception {
        MatrixLibraries ml = new MatrixLibraries(MatrixLibrariesFormat.LATEX);
        String s = ml.exportToString(FileFormat.TEX, new Object[0]);
        s = s.replaceAll("table", "sidewaystable");
        s = s.replaceAll("\\\\centering", "");
        s = s.replaceAll("\\\\toprule", "");
        s = s.replaceAll("\\\\begin\\{tabular\\}", "\\\\caption{Overview of matrix libraries in Java}\n\\\\bigskip\n\\\\begin{centering}\n\\\\scalebox{0.85}{%\n\\\\begin{tabular}");
        s = s.replaceAll("latest version", "\\\\toprule\nlatest version");
        s = s.replaceAll("\\\\end\\{sidewaystable\\}", "");
        s = s.replaceAll("\\\\end\\{tabular\\}", "\\\\end{tabular}}\n\\\\end{centering}");
        s = s.replaceAll("version &", "\\\\toprule\nversion &");
        s = s.replaceAll("Java 1.4 &", "\\\\midrule\nJava 1.4 &");
        s = s.replaceAll("multithreaded &", "\\\\midrule\nmultithreaded &");
        s = s.replaceAll("dense &", "\\\\midrule\ndense &");
        s = s.replaceAll("complex &", "\\\\midrule\ncomplex &");
        s = s.replaceAll("2D &", "\\\\midrule\n2D &");
        s = s.replaceAll("transpose &", "\\\\midrule\ntranspose &");
        s = s.replaceAll("inverse &", "\\\\midrule\ninverse &");
        s = String.valueOf(s) + "\\medskip" + "\n";
        s = String.valueOf(s) + "\\begin{tabular}{p{0.33\\textwidth}p{0.33\\textwidth}p{0.33\\textwidth}}\n";
        s = String.valueOf(s) + "\\renewcommand{\\tabcolsep}{30pt}";
        List<String> fn = ml.getFootnotes();
        Collections.sort(fn);
        int i = 0;
        while (i < fn.size()) {
            String f = fn.get(i);
            s = String.valueOf(s) + f;
            s = i % 3 == 2 ? String.valueOf(s) + "\\\\\n" : String.valueOf(s) + " & ";
            ++i;
        }
        s = String.valueOf(s) + "\\end{tabular}\n";
        s = String.valueOf(s) + "\\end{sidewaystable}";
        System.out.println(s);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatrixLibrariesFormat {
        DEFAULT,
        LATEX,
        HTML;

    }
}

