/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.gui.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import org.ujmp.gui.interfaces.CanBeRepainted;
import org.ujmp.gui.util.Executor;

public class GraphicsExecutor {
    private static final int count = Runtime.getRuntime().availableProcessors();
    private static List<Executor> executors = new ArrayList<Executor>(count);

    static {
        int i = 0;
        while (i < count) {
            Executor executor = new Executor();
            executors.add(executor);
            ++i;
        }
    }

    public static final void scheduleUpdate(CanBeRepainted component) {
        Component c = (Component)((Object)component);
        while (c != null && !(c instanceof JFrame)) {
            c = c.getParent();
        }
        if (c != null && c.isVisible()) {
            Executor executor = GraphicsExecutor.getExecutor(component);
            executor.sheduleUpdate(component);
        }
    }

    private static Executor getExecutor(CanBeRepainted component) {
        return executors.get(Math.abs(component.hashCode()) % count);
    }

    public static final void setFinished(CanBeRepainted component) {
        executors.get(component.hashCode() % count).setFinished(component);
    }
}

