/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.ujmp.core.Matrix;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.objectmatrix.stub.AbstractDenseObjectMatrix2D;

public class DenseJackcessMatrix2D
extends AbstractDenseObjectMatrix2D
implements Closeable {
    private static final long serialVersionUID = -6342663672866315180L;
    private Database database = null;
    private Table table = null;
    private List<Column> columns = null;
    Cursor cursor = null;

    public DenseJackcessMatrix2D(File file, String tablename) throws IOException {
        this.database = Database.open((File)file);
        this.table = this.database.getTable(tablename);
        this.columns = this.table.getColumns();
        this.cursor = Cursor.createCursor((Table)this.table);
    }

    public DenseJackcessMatrix2D(File file, Matrix matrix) throws IOException {
        this(file, "ujmp-matrix", matrix);
    }

    public DenseJackcessMatrix2D(File file, String tablename, Matrix matrix) throws IOException {
        try {
            this.database = Database.create((File)file);
            TableBuilder tb = new TableBuilder(tablename);
            int i = 0;
            while ((long)i < matrix.getColumnCount()) {
                ColumnBuilder cb = new ColumnBuilder("Column" + i);
                switch (matrix.getValueType()) {
                    case DOUBLE: {
                        cb.setSQLType(8);
                        break;
                    }
                    case INT: {
                        cb.setSQLType(4);
                        break;
                    }
                    default: {
                        cb.setSQLType(12);
                    }
                }
                tb.addColumn(cb.toColumn());
                ++i;
            }
            this.table = tb.toTable(this.database);
            int r = 0;
            while ((long)r < matrix.getRowCount()) {
                Object[] data = new Object[(int)matrix.getColumnCount()];
                int c = 0;
                while ((long)c < matrix.getColumnCount()) {
                    data[c] = matrix.getAsObject(r, c);
                    ++c;
                }
                this.table.addRow(data);
                ++r;
            }
        }
        catch (SQLException e) {
            throw new MatrixException(e);
        }
    }

    public synchronized Object getObject(long row, long column) throws MatrixException {
        return this.getObject((int)row, (int)column);
    }

    public synchronized Object getObject(int row, int column) throws MatrixException {
        if (this.columns == null || this.cursor == null) {
            return null;
        }
        try {
            Column c = this.columns.get(column);
            this.cursor.reset();
            this.cursor.moveNextRows(row + 1);
            return this.cursor.getCurrentRowValue(c);
        }
        catch (IOException e) {
            throw new MatrixException(e);
        }
    }

    public void setObject(Object value, long row, long column) {
    }

    public void setObject(Object value, int row, int column) {
    }

    public long[] getSize() {
        if (this.table == null) {
            return Coordinates.ZERO2D;
        }
        return new long[]{this.table.getRowCount(), this.table.getColumnCount()};
    }

    public void close() throws IOException {
        this.database.close();
    }
}

