/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jexcelapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import jxl.Cell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.enums.ValueType;
import org.ujmp.core.exceptions.MatrixException;

public abstract class ImportMatrixXLS {
    public static final Matrix fromFile(File file, Object ... parameters) throws MatrixException, IOException {
        try {
            Workbook workbook = Workbook.getWorkbook((File)file);
            Sheet sheet = workbook.getSheet(0);
            int rows = sheet.getRows();
            int columns = sheet.getColumns();
            Matrix matrix = MatrixFactory.zeros(ValueType.OBJECT, rows, columns);
            int row = 0;
            while (row < rows) {
                int column = 0;
                while (column < columns) {
                    Cell c = sheet.getCell(column, row);
                    Object o = null;
                    o = c instanceof NumberCell ? Double.valueOf(((NumberCell)c).getValue()) : c.getContents();
                    matrix.setAsObject(o, row, column);
                    ++column;
                }
                ++row;
            }
            workbook.close();
            return matrix;
        }
        catch (BiffException e) {
            throw new MatrixException("could not import from file " + file, e);
        }
    }

    public static final Matrix fromStream(InputStream inputStream, Object ... parameters) throws IOException, MatrixException {
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)inputStream);
            Sheet sheet = workbook.getSheet(0);
            int rows = sheet.getRows();
            int columns = sheet.getColumns();
            Matrix matrix = MatrixFactory.zeros(ValueType.OBJECT, rows, columns);
            int row = 0;
            while (row < rows) {
                int column = 0;
                while (column < columns) {
                    Cell c = sheet.getCell(column, row);
                    Object o = null;
                    o = c instanceof NumberCell ? Double.valueOf(((NumberCell)c).getValue()) : c.getContents();
                    matrix.setAsObject(o, row, column);
                    ++column;
                }
                ++row;
            }
            workbook.close();
            return matrix;
        }
        catch (BiffException e) {
            throw new MatrixException("could not import from stream", e);
        }
    }
}

