/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jsci;

import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Calculation;
import org.ujmp.core.coordinates.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSciDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<AbstractDoubleMatrix> {
    private static final long serialVersionUID = -4314440110211101868L;
    private AbstractDoubleMatrix matrix = null;

    public JSciDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    public JSciDenseDoubleMatrix2D(long ... size) {
        if (Coordinates.product(size) != 0L) {
            this.matrix = size[0] == size[1] ? new DoubleSquareMatrix((int)size[0]) : new DoubleMatrix((int)size[0], (int)size[1]);
        }
    }

    public JSciDenseDoubleMatrix2D(AbstractDoubleMatrix m) {
        this.matrix = m;
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getElement((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    @Override
    public long[] getSize() {
        long[] lArray;
        if (this.matrix == null) {
            lArray = Coordinates.ZERO2D;
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = this.matrix.rows();
            lArray = lArray2;
            lArray2[1] = this.matrix.columns();
        }
        return lArray;
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setElement((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setElement(row, column, value);
    }

    @Override
    public Matrix transpose() {
        return new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)this.matrix.transpose());
    }

    @Override
    public Matrix inv() {
        if (this.matrix instanceof DoubleSquareMatrix) {
            return new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)((DoubleSquareMatrix)this.matrix).inverse());
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public Matrix chol() {
        if (this.matrix instanceof DoubleSquareMatrix) {
            AbstractDoubleSquareMatrix[] chol = ((DoubleSquareMatrix)this.matrix).choleskyDecompose();
            return new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)chol[0]);
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public Matrix[] lu() {
        if (this.matrix instanceof DoubleSquareMatrix) {
            AbstractDoubleSquareMatrix[] lu = ((DoubleSquareMatrix)this.matrix).luDecompose();
            JSciDenseDoubleMatrix2D l = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)lu[0]);
            JSciDenseDoubleMatrix2D u = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)lu[1]);
            JSciDenseDoubleMatrix2D p = new JSciDenseDoubleMatrix2D(this.getRowCount(), this.getRowCount());
            p.eye(Calculation.Ret.ORIG);
            return new Matrix[]{l, u, p};
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public Matrix[] qr() {
        if (this.matrix instanceof DoubleSquareMatrix) {
            AbstractDoubleSquareMatrix[] qr = ((DoubleSquareMatrix)this.matrix).qrDecompose();
            JSciDenseDoubleMatrix2D q = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)qr[0]);
            JSciDenseDoubleMatrix2D r = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)qr[1]);
            return new Matrix[]{q, r};
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public Matrix[] svd() {
        if (this.matrix instanceof DoubleSquareMatrix) {
            AbstractDoubleSquareMatrix[] svd = ((DoubleSquareMatrix)this.matrix).singularValueDecompose();
            JSciDenseDoubleMatrix2D u = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)svd[0]);
            JSciDenseDoubleMatrix2D s = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)svd[1]);
            JSciDenseDoubleMatrix2D v = new JSciDenseDoubleMatrix2D((AbstractDoubleMatrix)svd[2]);
            return new Matrix[]{u, s, v};
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof JSciDenseDoubleMatrix2D) {
            return new JSciDenseDoubleMatrix2D(this.matrix.multiply(((JSciDenseDoubleMatrix2D)m).matrix));
        }
        return super.mtimes(m);
    }

    @Override
    public AbstractDoubleMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(AbstractDoubleMatrix object) {
        this.matrix = object;
    }
}

