/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ojalgo.calculation;

import org.ojalgo.matrix.decomposition.LUDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ujmp.core.Matrix;
import org.ujmp.ojalgo.OjalgoDenseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LU
implements org.ujmp.core.doublematrix.calculation.general.decomposition.LU<Matrix> {
    public static LU INSTANCE = new LU();

    public Matrix[] calc(Matrix source) {
        try {
            org.ojalgo.matrix.decomposition.LU lu = LUDecomposition.makePrimitive();
            PrimitiveDenseStore matrix = null;
            matrix = source instanceof OjalgoDenseDoubleMatrix2D ? ((OjalgoDenseDoubleMatrix2D)source).getWrappedObject() : new OjalgoDenseDoubleMatrix2D(source).getWrappedObject();
            lu.compute((MatrixStore)matrix);
            OjalgoDenseDoubleMatrix2D l = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)lu.getL());
            OjalgoDenseDoubleMatrix2D u = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)lu.getRowEchelonForm());
            int m = (int)source.getRowCount();
            int[] piv = lu.getPivotOrder();
            OjalgoDenseDoubleMatrix2D p = new OjalgoDenseDoubleMatrix2D(m, m);
            int i = 0;
            while (i < m) {
                p.setAsDouble(1.0, new long[]{i, piv[i]});
                ++i;
            }
            return new Matrix[]{l, u, p};
        }
        catch (Throwable t) {
            return org.ujmp.core.doublematrix.calculation.general.decomposition.LU.UJMP.calc(source);
        }
    }

    @Override
    public Matrix solve(Matrix a, Matrix b) {
        try {
            org.ojalgo.matrix.decomposition.LU lu = LUDecomposition.makePrimitive();
            PrimitiveDenseStore a2 = null;
            PrimitiveDenseStore b2 = null;
            a2 = a instanceof OjalgoDenseDoubleMatrix2D ? ((OjalgoDenseDoubleMatrix2D)a).getWrappedObject() : new OjalgoDenseDoubleMatrix2D(a).getWrappedObject();
            b2 = b instanceof OjalgoDenseDoubleMatrix2D ? ((OjalgoDenseDoubleMatrix2D)b).getWrappedObject() : new OjalgoDenseDoubleMatrix2D(b).getWrappedObject();
            lu.compute((MatrixStore)a2);
            return new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)lu.solve((MatrixStore)b2));
        }
        catch (Throwable t) {
            return org.ujmp.core.doublematrix.calculation.general.decomposition.LU.UJMP.solve(a, b);
        }
    }
}

