/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.parallelcolt;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleBlas;
import cern.colt.matrix.tdouble.algo.SmpDoubleBlas;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleCholeskyDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleEigenvalueDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleLUDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleQRDecomposition;
import cern.colt.matrix.tdouble.algo.decomposition.DenseDoubleSingularValueDecompositionDC;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelColtDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DenseDoubleMatrix2D> {
    private static final long serialVersionUID = -1941030601886654699L;
    private static final DoubleBlas BLAS = new SmpDoubleBlas();
    private static final DenseDoubleAlgebra ALG = new DenseDoubleAlgebra();
    private DenseDoubleMatrix2D matrix = null;

    public ParallelColtDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DenseDoubleMatrix2D((int)size[0], (int)size[1]);
    }

    public ParallelColtDenseDoubleMatrix2D(DoubleMatrix2D m) {
        this.matrix = m instanceof DenseDoubleMatrix2D ? (DenseDoubleMatrix2D)m : new DenseDoubleMatrix2D(m.toArray());
    }

    public ParallelColtDenseDoubleMatrix2D(DenseDoubleMatrix2D m) {
        this.matrix = m;
    }

    public ParallelColtDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setAsDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getQuick((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getQuick(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.rows(), this.matrix.columns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setQuick((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setQuick(row, column, value);
    }

    @Override
    public DenseDoubleMatrix2D getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(DenseDoubleMatrix2D object) {
        this.matrix = object;
    }

    @Override
    public Matrix plus(double value) {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(DoubleFunctions.plus((double)value)));
    }

    @Override
    public Matrix inv() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)ALG.inverse((DoubleMatrix2D)this.matrix));
    }

    @Override
    public Matrix times(double value) {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy().assign(DoubleFunctions.mult((double)value)));
    }

    @Override
    public Matrix transpose() {
        return new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.viewDice().copy());
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DoubleMatrix2D result = this.matrix.copy();
            BLAS.daxpy(1.0, (DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).matrix, result);
            return new ParallelColtDenseDoubleMatrix2D(result);
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DoubleMatrix2D result = this.matrix.copy();
            BLAS.daxpy(-1.0, (DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).matrix, result);
            return new ParallelColtDenseDoubleMatrix2D(result);
        }
        return super.plus(m);
    }

    @Override
    public Matrix mtimes(Matrix m) throws MatrixException {
        if (m instanceof ParallelColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D ret = new DenseDoubleMatrix2D((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.zMult((DoubleMatrix2D)((ParallelColtDenseDoubleMatrix2D)m).matrix, (DoubleMatrix2D)ret);
            return new ParallelColtDenseDoubleMatrix2D(ret);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix[] svd() {
        DenseDoubleSingularValueDecompositionDC svd = new DenseDoubleSingularValueDecompositionDC((DoubleMatrix2D)this.matrix, true, false);
        ParallelColtDenseDoubleMatrix2D u = new ParallelColtDenseDoubleMatrix2D(svd.getU());
        ParallelColtDenseDoubleMatrix2D s = new ParallelColtDenseDoubleMatrix2D(svd.getS());
        ParallelColtDenseDoubleMatrix2D v = new ParallelColtDenseDoubleMatrix2D(svd.getV());
        return new Matrix[]{u, s, v};
    }

    @Override
    public Matrix[] eig() {
        DenseDoubleEigenvalueDecomposition eig = new DenseDoubleEigenvalueDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D v = new ParallelColtDenseDoubleMatrix2D(eig.getV());
        ParallelColtDenseDoubleMatrix2D d = new ParallelColtDenseDoubleMatrix2D(eig.getD());
        return new Matrix[]{v, d};
    }

    @Override
    public Matrix[] qr() {
        DenseDoubleQRDecomposition qr = new DenseDoubleQRDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D q = new ParallelColtDenseDoubleMatrix2D(qr.getQ(false));
        ParallelColtDenseDoubleMatrix2D r = new ParallelColtDenseDoubleMatrix2D(qr.getR(false));
        return new Matrix[]{q, r};
    }

    @Override
    public Matrix[] lu() {
        if (this.getRowCount() >= this.getColumnCount()) {
            DenseDoubleLUDecomposition lu = new DenseDoubleLUDecomposition((DoubleMatrix2D)this.matrix);
            ParallelColtDenseDoubleMatrix2D l = new ParallelColtDenseDoubleMatrix2D(lu.getL());
            ParallelColtDenseDoubleMatrix2D u = new ParallelColtDenseDoubleMatrix2D(lu.getU().viewPart(0, 0, (int)this.getColumnCount(), (int)this.getColumnCount()));
            int m = (int)this.getRowCount();
            int[] piv = lu.getPivot();
            ParallelColtDenseDoubleMatrix2D p = new ParallelColtDenseDoubleMatrix2D(m, m);
            int i = 0;
            while (i < m) {
                p.setAsDouble(1.0, new long[]{i, piv[i]});
                ++i;
            }
            return new Matrix[]{l, u, p};
        }
        throw new MatrixException("only supported for matrices m>=n");
    }

    @Override
    public Matrix chol() {
        DenseDoubleCholeskyDecomposition chol = new DenseDoubleCholeskyDecomposition((DoubleMatrix2D)this.matrix);
        ParallelColtDenseDoubleMatrix2D r = new ParallelColtDenseDoubleMatrix2D(chol.getL());
        return r;
    }

    @Override
    public Matrix copy() {
        ParallelColtDenseDoubleMatrix2D m = new ParallelColtDenseDoubleMatrix2D((DenseDoubleMatrix2D)this.matrix.copy());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public Matrix solve(Matrix b) {
        if (b instanceof ParallelColtDenseDoubleMatrix2D) {
            DenseDoubleMatrix2D b2 = ((ParallelColtDenseDoubleMatrix2D)b).matrix;
            DoubleMatrix2D result = ALG.solve((DoubleMatrix2D)this.matrix, (DoubleMatrix2D)b2);
            return new ParallelColtDenseDoubleMatrix2D(result);
        }
        return super.solve(b);
    }
}

