/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.PlusScalarCalculation;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusScalarSparseMatrix
implements PlusScalarCalculation<SparseMatrix, SparseMatrix> {
    PlusScalarSparseMatrix() {
    }

    @Override
    public final void calc(SparseMatrix source, BigDecimal value, SparseMatrix target) {
        VerifyUtil.assertSameSize((Matrix)source, (Matrix)target);
        for (long[] c : source.availableCoordinates()) {
            BigDecimal svalue = source.getAsBigDecimal(c);
            BigDecimal result = MathUtil.plus(svalue, value);
            target.setAsBigDecimal(result, c);
        }
    }

    @Override
    public final void calc(SparseMatrix source, double value, SparseMatrix target) {
        this.calc(source, new BigDecimal(value, MathUtil.getDefaultMathContext()), target);
    }
}

