/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import org.ujmp.core.Coordinates;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.Transpose;
import org.ujmp.core.calculation.TransposeCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.matrix.DenseMatrix;
import org.ujmp.core.matrix.DenseMatrix2D;
import org.ujmp.core.matrix.SparseMatrix;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransposeMatrix
implements TransposeCalculation<Matrix, Matrix> {
    TransposeMatrix() {
    }

    @Override
    public final void calc(Matrix source, Matrix target) {
        if (source == target) {
            throw new MatrixException("cannot transpose into original matrix");
        }
        if (source instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            Transpose.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source, (DenseDoubleMatrix2D)target);
        } else if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            Transpose.DENSEMATRIX2D.calc((DenseMatrix2D)source, (DenseMatrix2D)target);
        } else if (source instanceof DenseMatrix && target instanceof DenseMatrix) {
            Transpose.DENSEMATRIX.calc((DenseMatrix)source, (DenseMatrix)target);
        } else if (source instanceof SparseMatrix && target instanceof SparseMatrix) {
            Transpose.SPARSEMATRIX.calc((SparseMatrix)source, (SparseMatrix)target);
        } else {
            VerifyUtil.assert2D(source);
            VerifyUtil.assert2D(target);
            VerifyUtil.assertEquals(source.getRowCount(), target.getColumnCount(), "matrices have wrong size");
            VerifyUtil.assertEquals(source.getColumnCount(), target.getRowCount(), "matrices have wrong size");
            for (long[] c : source.allCoordinates()) {
                Object o = source.getAsObject(c);
                target.setAsObject(o, Coordinates.transpose(c));
            }
        }
    }
}

