/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jblas;

import org.jblas.DoubleMatrix;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.HasColumnMajorDoubleArray1D;
import org.ujmp.core.interfaces.HasRowMajorDoubleArray2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.jblas.calculation.Chol;
import org.ujmp.jblas.calculation.Eig;
import org.ujmp.jblas.calculation.Inv;
import org.ujmp.jblas.calculation.InvSPD;
import org.ujmp.jblas.calculation.LU;
import org.ujmp.jblas.calculation.Solve;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBlasDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<DoubleMatrix> {
    private static final long serialVersionUID = 4929284378405884509L;
    private DoubleMatrix matrix;

    public JBlasDenseDoubleMatrix2D(long ... size) {
        this.matrix = new DoubleMatrix((int)size[0], (int)size[1]);
    }

    public JBlasDenseDoubleMatrix2D(DoubleMatrix matrix) {
        this.matrix = matrix;
    }

    public JBlasDenseDoubleMatrix2D(Matrix source) throws MatrixException {
        if (source instanceof HasColumnMajorDoubleArray1D) {
            double[] data = ((HasColumnMajorDoubleArray1D)((Object)source)).getColumnMajorDoubleArray1D();
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount(), data);
        } else if (source instanceof HasRowMajorDoubleArray2D) {
            double[][] data = ((HasRowMajorDoubleArray2D)((Object)source)).getRowMajorDoubleArray2D();
            this.matrix = new DoubleMatrix(data);
        } else if (source instanceof DenseDoubleMatrix2D) {
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount());
            DenseDoubleMatrix2D m2 = (DenseDoubleMatrix2D)source;
            int r = (int)source.getRowCount();
            while (--r >= 0) {
                int c = (int)source.getColumnCount();
                while (--c >= 0) {
                    this.matrix.put(r, c, m2.getDouble(r, c));
                }
            }
        } else {
            this.matrix = new DoubleMatrix((int)source.getRowCount(), (int)source.getColumnCount());
            for (long[] c : source.availableCoordinates()) {
                this.setDouble(source.getAsDouble(c), c);
            }
        }
    }

    public JBlasDenseDoubleMatrix2D(long rowCount, long columnCount, double[] doubleArray) {
        this.matrix = new DoubleMatrix((int)rowCount, (int)columnCount, doubleArray);
    }

    @Override
    public Matrix inv() throws MatrixException {
        return Inv.INSTANCE.calc(this);
    }

    @Override
    public Matrix invSPD() throws MatrixException {
        return InvSPD.INSTANCE.calc(this);
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column);
    }

    @Override
    public long[] getSize() {
        return new long[]{this.matrix.getRows(), this.matrix.getColumns()};
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.put((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.put(row, column, value);
    }

    @Override
    public DoubleMatrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(DoubleMatrix object) {
        this.matrix = object;
    }

    @Override
    public final Matrix copy() throws MatrixException {
        JBlasDenseDoubleMatrix2D m = new JBlasDenseDoubleMatrix2D(this.matrix.dup());
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    @Override
    public Matrix transpose() {
        return new JBlasDenseDoubleMatrix2D(this.matrix.transpose());
    }

    @Override
    public Matrix[] lu() {
        return LU.INSTANCE.calc(this);
    }

    @Override
    public Matrix[] eig() {
        return Eig.INSTANCE.calc(this);
    }

    @Override
    public Matrix chol() {
        return Chol.INSTANCE.calc(this);
    }

    @Override
    public Matrix mtimes(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)m.getColumnCount());
            this.matrix.mmuli(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            return new JBlasDenseDoubleMatrix2D(r);
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix plus(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
            this.matrix.addi(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            return new JBlasDenseDoubleMatrix2D(r);
        }
        return super.plus(m);
    }

    @Override
    public Matrix minus(Matrix m) {
        if (m instanceof JBlasDenseDoubleMatrix2D) {
            DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
            this.matrix.subi(((JBlasDenseDoubleMatrix2D)m).matrix, r);
            return new JBlasDenseDoubleMatrix2D(r);
        }
        return super.minus(m);
    }

    @Override
    public Matrix times(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        return new JBlasDenseDoubleMatrix2D(this.matrix.muli(value, r));
    }

    @Override
    public Matrix divide(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        return new JBlasDenseDoubleMatrix2D(this.matrix.divi(value, r));
    }

    @Override
    public Matrix plus(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        return new JBlasDenseDoubleMatrix2D(this.matrix.addi(value, r));
    }

    @Override
    public Matrix minus(double value) {
        DoubleMatrix r = new DoubleMatrix((int)this.getRowCount(), (int)this.getColumnCount());
        return new JBlasDenseDoubleMatrix2D(this.matrix.subi(value, r));
    }

    @Override
    public Matrix solve(Matrix b) {
        return Solve.INSTANCE.calc(this, b);
    }
}

