/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.model;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jopendocument.io.SaxContentUnmarshaller;
import org.jopendocument.io.SaxStylesUnmarshaller;
import org.jopendocument.model.PrintedPage;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.util.ImageUtils;
import org.jopendocument.util.StreamUtils;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class OpenDocument {
    private static final int MAX_IN_MEMORY_HQ_IMAGE = 10;
    private OfficeAutomaticStyles autoStyles;
    private OfficeBody body;
    private final Map<String, Image> images = new HashMap<String, Image>();
    private final Map<String, Image> imagesHQ = new HashMap<String, Image>();
    private OfficeMasterStyles masterStyles;
    private List<PrintedPage> pages;
    private OfficeStyles styles;
    private ZipFile zipFile;
    private Map<Integer, Integer> splitRowValues = new HashMap<Integer, Integer>();

    public OpenDocument() {
    }

    public OpenDocument(File file) {
        this.loadFrom(file);
        this.loadODSP();
    }

    private void computePages() {
        this.pages = new ArrayList<PrintedPage>();
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        int n = 0;
        for (OfficeSpreadsheet officeSpreadsheet : list) {
            List<TableTable> list2 = officeSpreadsheet.getTables();
            for (TableTable tableTable : list2) {
                StylePageLayoutProperties stylePageLayoutProperties = tableTable.getPageLayoutProperties();
                int n2 = 0;
                if (stylePageLayoutProperties != null) {
                    n2 = stylePageLayoutProperties.getPageHeight();
                }
                int n3 = tableTable.getPrintStartRow();
                int n4 = tableTable.getPrintStopRow();
                int n5 = tableTable.getPrintStartCol();
                int n6 = tableTable.getPrintStopCol();
                System.out.println("PageHeigth:" + n2);
                List<TableTableRow> list3 = tableTable.getRowsInRange(n3, n4);
                int n7 = this.getSplitEveryRow(list2.indexOf(tableTable));
                PrintedPage printedPage = new PrintedPage();
                int n8 = list3.size();
                for (int i = 0; i < n8; ++i) {
                    TableTableRow tableTableRow = list3.get(i);
                    printedPage.addRow(tableTableRow);
                    if (n7 > 0) {
                        if (i <= 0 || (i + 1) % (n7 + 1) != 0) continue;
                        this.pages.add(printedPage);
                        printedPage = new PrintedPage();
                        continue;
                    }
                    if ((n += tableTableRow.getHeight()) <= n2) continue;
                    n = 0;
                    this.pages.add(printedPage);
                    printedPage = new PrintedPage();
                }
                if (this.pages.contains(printedPage) || printedPage.isEmpty()) continue;
                this.pages.add(printedPage);
            }
        }
    }

    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }

    public OfficeBody getBody() {
        return this.body;
    }

    public Image getImage(String string) {
        Object object;
        Object object2;
        Image image = this.images.get(string);
        if (image != null) {
            return image;
        }
        ZipEntry zipEntry = this.zipFile.getEntry(string);
        byte[] byArray = null;
        try {
            int n;
            object2 = this.zipFile.getInputStream(zipEntry);
            object = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[4096];
            while ((n = ((InputStream)object2).read(byArray2, 0, 4096)) != -1) {
                ((ByteArrayOutputStream)object).write(byArray2, 0, n);
            }
            ((ByteArrayOutputStream)object).close();
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            ((InputStream)object2).read(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object2 = new ImageIcon(byArray);
        object = ((ImageIcon)object2).getImage();
        if (((ImageIcon)object2).getImageLoadStatus() != 8) {
            throw new IllegalStateException("Unable to load:'" + string + "'");
        }
        this.images.put(string, (Image)object);
        return object;
    }

    public Image getImage(String string, int n, int n2) {
        String string2 = n + "," + n2;
        Image image = this.imagesHQ.get(string2);
        if (image != null) {
            return image;
        }
        image = ImageUtils.createQualityResizedImage(this.getImage(string), n, n2);
        if (this.imagesHQ.size() > 10) {
            this.imagesHQ.clear();
        }
        this.imagesHQ.put(string2, image);
        return image;
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    public PrintedPage getPrintedPage(int n) {
        if (this.pages == null) {
            this.computePages();
        }
        return this.pages.get(n);
    }

    public int getPrintedPageCount() {
        return this.pages.size();
    }

    private void loadODSP() {
        String string = this.getZipFile().getName() + "p";
        File file = new File(string);
        if (!file.exists()) {
            System.err.println("ODSP Not Exist");
            return;
        }
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(file);
            Element element = document.getRootElement();
            Element element2 = element.getChild("spliteveryrow");
            if (element2 != null) {
                List list = element2.getChildren("sheet");
                for (Element element3 : list) {
                    String string2 = element3.getAttributeValue("number");
                    if (string2 == null || string2.trim().length() <= 0) continue;
                    int n = Integer.valueOf(string2);
                    String string3 = element3.getValue();
                    if (string3 == null || string3.trim().length() <= 0) continue;
                    int n2 = Integer.valueOf(string3);
                    int n3 = Integer.valueOf(string2);
                    this.splitRowValues.put(n3, n2);
                }
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public int getSplitEveryRow(int n) {
        Integer n2 = this.splitRowValues.get(n);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    public OfficeStyles getStyles() {
        return this.styles;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void importAutoStylesFrom(OfficeAutomaticStyles officeAutomaticStyles) {
        for (StyleStyle styleStyle : officeAutomaticStyles.getStyles()) {
            this.autoStyles.addStyle(styleStyle);
        }
    }

    public void init(OfficeBody officeBody, OfficeAutomaticStyles officeAutomaticStyles, OfficeStyles officeStyles, OfficeAutomaticStyles officeAutomaticStyles2, OfficeMasterStyles officeMasterStyles) {
        if (officeBody == null) {
            throw new IllegalArgumentException("OfficeBody cannot be null");
        }
        if (officeAutomaticStyles == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (officeStyles == null) {
            throw new IllegalArgumentException("OfficeStyles cannot be null");
        }
        if (officeAutomaticStyles2 == null) {
            throw new IllegalArgumentException("OfficeAutomaticStyles cannot be null");
        }
        if (officeMasterStyles == null) {
            throw new IllegalArgumentException("OfficeMasterStyles cannot be null");
        }
        this.body = officeBody;
        this.body.setDocument(this);
        this.styles = officeStyles;
        this.autoStyles = officeAutomaticStyles2;
        this.importAutoStylesFrom(officeAutomaticStyles);
        StyleDefaultStyle styleDefaultStyle = officeStyles.getDefaultCellStyle();
        if (styleDefaultStyle == null) {
            styleDefaultStyle = new StyleDefaultStyle();
            styleDefaultStyle.setStyleFamily("table-cell");
        }
        StyleStyle styleStyle = new StyleStyle();
        styleStyle.setStyleName("Default");
        styleStyle.setTextProperties(styleDefaultStyle.getStyleTextProperties());
        styleStyle.setStyleProperties(styleDefaultStyle.getStyleProperties());
        this.autoStyles.addStyle(styleStyle);
        this.masterStyles = officeMasterStyles;
    }

    public void loadFrom(File file) {
        SaxContentUnmarshaller saxContentUnmarshaller = new SaxContentUnmarshaller(this);
        SaxStylesUnmarshaller saxStylesUnmarshaller = new SaxStylesUnmarshaller();
        try {
            this.zipFile = new ZipFile(file);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(saxContentUnmarshaller);
            ZipEntry zipEntry = this.zipFile.getEntry("content.xml");
            InputSource inputSource = new InputSource(new InputStreamReader(this.zipFile.getInputStream(zipEntry), "UTF-8"));
            xMLReader.parse(inputSource);
            xMLReader.setContentHandler(saxStylesUnmarshaller);
            ZipEntry zipEntry2 = this.zipFile.getEntry("styles.xml");
            if (zipEntry2 != null) {
                InputSource inputSource2 = new InputSource(new InputStreamReader(this.zipFile.getInputStream(zipEntry2), "UTF-8"));
                xMLReader.parse(inputSource2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.init(saxContentUnmarshaller.getBody(), saxContentUnmarshaller.getAutomaticstyles(), saxStylesUnmarshaller.getStyles(), saxStylesUnmarshaller.getAutomaticStyles(), saxStylesUnmarshaller.getMasterStyles());
    }

    public void loadFrom(String string) {
        this.loadFrom(new File(string));
    }

    public void loadFrom(URL uRL) throws IOException {
        if (!uRL.getPath().toLowerCase().endsWith(".ods")) {
            throw new IllegalArgumentException("This class is only for ODS files");
        }
        File file = File.createTempFile("jOpenDocument", ".ods");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamUtils.copy(uRL.openStream(), fileOutputStream);
        fileOutputStream.close();
        this.loadFrom(file);
    }

    public void preloadImage(String string) {
        this.getImage(string);
    }

    public void setAutomaticStyles(OfficeAutomaticStyles officeAutomaticStyles) {
        this.autoStyles = officeAutomaticStyles;
    }

    public void setMasterStyles(OfficeMasterStyles officeMasterStyles) {
        this.masterStyles = officeMasterStyles;
    }
}

