/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import org.jdom.Document;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;

public abstract class StyledNode<S extends StyleStyle, D extends ODDocument>
extends ODNode {
    private final StyleDesc<S> styleClass;

    public StyledNode(Element element, Class<S> clazz) {
        super(element);
        if (clazz == null) {
            throw new NullPointerException("null style class");
        }
        this.styleClass = StyleStyle.getStyleDesc(clazz, XMLVersion.getVersion(this.getElement()));
        assert (this.styleClass.getRefElements().contains(this.getElement().getQualifiedName())) : this.getElement().getQualifiedName() + " not in " + this.styleClass;
    }

    public abstract D getODDocument();

    public final S getStyle() {
        D d = this.getODDocument();
        return d == null ? null : (S)this.getStyle(d.getPackage(), this.getElement().getDocument());
    }

    protected final S getStyle(ODPackage oDPackage, Document document) {
        return this.styleClass.findStyle(oDPackage, document, this.getStyleName());
    }

    public final S getPrivateStyle() {
        S s = this.getStyle();
        if (((StyleStyle)s).isReferencedAtMostOnce()) {
            return s;
        }
        StyleStyle styleStyle = (StyleStyle)this.styleClass.getStyleClass().cast(((StyleStyle)s).dup());
        this.setStyleName(styleStyle.getName());
        assert (((StyleStyle)this.getStyle()).equals(styleStyle));
        return (S)styleStyle;
    }

    protected String getStyleName() {
        return this.getElement().getAttributeValue("style-name", this.getElement().getNamespace());
    }

    public final void setStyleName(String string) {
        this.getElement().setAttribute("style-name", string, this.getElement().getNamespace());
    }
}

