/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import java.io.Serializable;
import moa.AbstractMOAObject;
import moa.classifiers.AttributeClassObserver;
import moa.classifiers.AttributeSplitSuggestion;
import moa.classifiers.NumericAttributeBinaryTest;
import moa.classifiers.SplitCriterion;
import moa.core.DoubleVector;
import weka.core.Utils;

public class BinaryTreeNumericAttributeClassObserver
extends AbstractMOAObject
implements AttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected Node root = null;

    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal)) {
            if (this.root == null) {
                this.root = new Node(attVal, classVal, weight);
            } else {
                this.root.insertValue(attVal, classVal, weight);
            }
        }
    }

    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        return 0.0;
    }

    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        return this.searchForBestSplitOption(this.root, null, null, null, false, criterion, preSplitDist, attIndex);
    }

    protected AttributeSplitSuggestion searchForBestSplitOption(Node currentNode, AttributeSplitSuggestion currentBestOption, double[] parentLeft, double[] parentRight, boolean leftChild, SplitCriterion criterion, double[] preSplitDist, int attIndex) {
        if (currentNode == null) {
            return currentBestOption;
        }
        DoubleVector leftDist = new DoubleVector();
        DoubleVector rightDist = new DoubleVector();
        if (parentLeft == null) {
            leftDist.addValues(currentNode.classCountsLeft);
            rightDist.addValues(currentNode.classCountsRight);
        } else {
            leftDist.addValues(parentLeft);
            rightDist.addValues(parentRight);
            if (leftChild) {
                leftDist.subtractValues(currentNode.classCountsRight);
                rightDist.addValues(currentNode.classCountsRight);
            } else {
                leftDist.addValues(currentNode.classCountsLeft);
                rightDist.subtractValues(currentNode.classCountsLeft);
            }
        }
        double[][] postSplitDists = new double[][]{leftDist.getArrayRef(), rightDist.getArrayRef()};
        double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
        if (currentBestOption == null || merit > currentBestOption.merit) {
            currentBestOption = new AttributeSplitSuggestion(new NumericAttributeBinaryTest(attIndex, currentNode.cut_point, true), postSplitDists, merit);
        }
        currentBestOption = this.searchForBestSplitOption(currentNode.left, currentBestOption, postSplitDists[0], postSplitDists[1], true, criterion, preSplitDist, attIndex);
        currentBestOption = this.searchForBestSplitOption(currentNode.right, currentBestOption, postSplitDists[0], postSplitDists[1], false, criterion, preSplitDist, attIndex);
        return currentBestOption;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected class Node
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public double cut_point;
        public DoubleVector classCountsLeft = new DoubleVector();
        public DoubleVector classCountsRight = new DoubleVector();
        public Node left;
        public Node right;

        public Node(double val, int label, double weight) {
            this.cut_point = val;
            this.classCountsLeft.addToValue(label, weight);
        }

        public void insertValue(double val, int label, double weight) {
            if (val == this.cut_point) {
                this.classCountsLeft.addToValue(label, weight);
            } else if (val <= this.cut_point) {
                this.classCountsLeft.addToValue(label, weight);
                if (this.left == null) {
                    this.left = new Node(val, label, weight);
                } else {
                    this.left.insertValue(val, label, weight);
                }
            } else {
                this.classCountsRight.addToValue(label, weight);
                if (this.right == null) {
                    this.right = new Node(val, label, weight);
                } else {
                    this.right.insertValue(val, label, weight);
                }
            }
        }
    }
}

