/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.AbstractMOAObject;
import moa.classifiers.AttributeClassObserver;
import moa.classifiers.AttributeSplitSuggestion;
import moa.classifiers.NumericAttributeBinaryTest;
import moa.classifiers.SplitCriterion;
import moa.core.AutoExpandVector;
import moa.core.DoubleVector;
import moa.core.GreenwaldKhannaQuantileSummary;
import weka.core.Utils;

public class GreenwaldKhannaNumericAttributeClassObserver
extends AbstractMOAObject
implements AttributeClassObserver {
    private static final long serialVersionUID = 1L;
    protected int numTuples;
    protected AutoExpandVector<GreenwaldKhannaQuantileSummary> attValDistPerClass = new AutoExpandVector();

    public GreenwaldKhannaNumericAttributeClassObserver(int numTuples) {
        this.numTuples = numTuples;
    }

    public void observeAttributeClass(double attVal, int classVal, double weight) {
        if (!Utils.isMissingValue((double)attVal)) {
            GreenwaldKhannaQuantileSummary valDist = this.attValDistPerClass.get(classVal);
            if (valDist == null) {
                valDist = new GreenwaldKhannaQuantileSummary(this.numTuples);
                this.attValDistPerClass.set(classVal, valDist);
            }
            valDist.insert(attVal);
        }
    }

    public double probabilityOfAttributeValueGivenClass(double attVal, int classVal) {
        return 0.0;
    }

    public AttributeSplitSuggestion getBestEvaluatedSplitSuggestion(SplitCriterion criterion, double[] preSplitDist, int attIndex, boolean binaryOnly) {
        AttributeSplitSuggestion bestSuggestion = null;
        for (GreenwaldKhannaQuantileSummary qs : this.attValDistPerClass) {
            double[] cutpoints;
            if (qs == null) continue;
            for (double cutpoint : cutpoints = qs.getSuggestedCutpoints()) {
                double[][] postSplitDists = this.getClassDistsResultingFromBinarySplit(cutpoint);
                double merit = criterion.getMeritOfSplit(preSplitDist, postSplitDists);
                if (bestSuggestion != null && !(merit > bestSuggestion.merit)) continue;
                bestSuggestion = new AttributeSplitSuggestion(new NumericAttributeBinaryTest(attIndex, cutpoint, true), postSplitDists, merit);
            }
        }
        return bestSuggestion;
    }

    public double[][] getClassDistsResultingFromBinarySplit(double splitValue) {
        DoubleVector lhsDist = new DoubleVector();
        DoubleVector rhsDist = new DoubleVector();
        for (int i = 0; i < this.attValDistPerClass.size(); ++i) {
            GreenwaldKhannaQuantileSummary estimator = this.attValDistPerClass.get(i);
            if (estimator == null) continue;
            long countBelow = estimator.getCountBelow(splitValue);
            lhsDist.addToValue(i, countBelow);
            rhsDist.addToValue(i, estimator.getTotalCount() - countBelow);
        }
        return new double[][]{lhsDist.getArrayRef(), rhsDist.getArrayRef()};
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

