/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import moa.AbstractMOAObject;
import moa.cluster.Clustering;
import moa.gui.visualization.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MeasureCollection
extends AbstractMOAObject {
    private static final long serialVersionUID = 1L;
    private String[] names = this.getNames();
    private ArrayList<Double>[] values;
    private ArrayList<Double>[] sortedValues;
    private double[] minValue;
    private double[] maxValue;
    private double[] sumValues;
    private boolean[] enabled;
    private double time;
    private HashMap<String, Integer> map;
    private int numMeasures = this.names.length;

    public MeasureCollection() {
        int i;
        this.map = new HashMap(this.numMeasures);
        for (i = 0; i < this.names.length; ++i) {
            this.map.put(this.names[i], i);
        }
        this.values = new ArrayList[this.numMeasures];
        this.sortedValues = new ArrayList[this.numMeasures];
        this.maxValue = new double[this.numMeasures];
        this.minValue = new double[this.numMeasures];
        this.sumValues = new double[this.numMeasures];
        this.enabled = this.getDefaultEnabled();
        this.time = 0.0;
        for (i = 0; i < this.numMeasures; ++i) {
            this.values[i] = new ArrayList();
            this.sortedValues[i] = new ArrayList();
            this.maxValue[i] = Double.MIN_VALUE;
            this.minValue[i] = Double.MAX_VALUE;
            this.sumValues[i] = 0.0;
        }
    }

    protected abstract String[] getNames();

    protected void addValue(int index, double value) {
        if (Double.isNaN(value)) {
            System.out.println("NaN for " + this.names[index]);
        }
        this.values[index].add(value);
        int n = index;
        this.sumValues[n] = this.sumValues[n] + value;
        if (value < this.minValue[index]) {
            this.minValue[index] = value;
        }
        if (value > this.maxValue[index]) {
            this.maxValue[index] = value;
        }
    }

    protected void addValue(String name, double value) {
        if (Double.isNaN(value)) {
            System.out.println("NaN for " + name);
        }
        if (this.map.containsKey(name)) {
            this.addValue(this.map.get(name), value);
        } else {
            System.out.println(name + " is not a valid measure key, no value added");
        }
    }

    public int getNumMeasures() {
        return this.numMeasures;
    }

    public String getName(int index) {
        return this.names[index];
    }

    public double getMaxValue(int index) {
        return this.maxValue[index];
    }

    public double getMinValue(int index) {
        return this.minValue[index];
    }

    public double getLastValue(int index) {
        if (this.values[index].size() < 1) {
            return Double.NaN;
        }
        return this.values[index].get(this.values[index].size() - 1);
    }

    public double getMean(int index) {
        if (this.values[index].size() < 1) {
            return Double.NaN;
        }
        return this.sumValues[index] / (double)this.values[index].size();
    }

    private void updateSortedValues(int index) {
        for (int i = this.sortedValues[index].size(); i < this.values[index].size(); ++i) {
            int insertIndex;
            double v = this.values[index].get(i);
            for (insertIndex = 0; !this.sortedValues[index].isEmpty() && insertIndex < this.sortedValues[index].size() && v > this.sortedValues[index].get(insertIndex); ++insertIndex) {
            }
            this.sortedValues[index].add(insertIndex, v);
        }
    }

    public void clean(int index) {
        this.sortedValues[index].clear();
    }

    public double getMedian(int index) {
        this.updateSortedValues(index);
        int size = this.sortedValues[index].size();
        if (size > 0) {
            if (size % 2 == 1) {
                return this.sortedValues[index].get(size / 2);
            }
            return (this.sortedValues[index].get((size - 1) / 2) + this.sortedValues[index].get((size - 1) / 2 + 1)) / 2.0;
        }
        return Double.NaN;
    }

    public double getLowerQuartile(int index) {
        this.updateSortedValues(index);
        int size = this.sortedValues[index].size();
        if (size > 11) {
            return this.sortedValues[index].get(Math.round((float)size * 0.25f));
        }
        return Double.NaN;
    }

    public double getUpperQuartile(int index) {
        this.updateSortedValues(index);
        int size = this.sortedValues[index].size();
        if (size > 11) {
            return this.sortedValues[index].get(Math.round((float)size * 0.75f - 1.0f));
        }
        return Double.NaN;
    }

    public int getNumberOfValues(int index) {
        return this.values[index].size();
    }

    public double getValue(int index, int i) {
        if (i >= this.values[index].size()) {
            return Double.NaN;
        }
        return this.values[index].get(i);
    }

    public ArrayList<Double> getAllValues(int index) {
        return this.values[index];
    }

    public void setEnabled(int index, boolean value) {
        this.enabled[index] = value;
    }

    public boolean isEnabled(int index) {
        return this.enabled[index];
    }

    public double getMeanRunningTime() {
        if (this.values[0].size() != 0) {
            return this.time / 1.0E7 / (double)this.values[0].size();
        }
        return 0.0;
    }

    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[this.numMeasures];
        for (int i = 0; i < defaults.length; ++i) {
            defaults[i] = true;
        }
        return defaults;
    }

    protected abstract void evaluateClustering(Clustering var1, Clustering var2, ArrayList<DataPoint> var3) throws Exception;

    public double evaluateClusteringPerformance(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        long start = System.nanoTime();
        this.evaluateClustering(clustering, trueClustering, points);
        long duration = System.nanoTime() - start;
        this.time += (double)duration;
        duration = (long)((double)duration / 1.0E7);
        return duration;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

