/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import moa.clusterers.AbstractClusterer;
import moa.evaluation.MeasureCollection;
import moa.gui.FileExtensionFilter;
import moa.gui.TextViewerPanel;
import moa.gui.clustertab.ClusteringAlgoPanel;
import moa.gui.clustertab.ClusteringEvalPanel;
import moa.gui.clustertab.ClusteringTabPanel;
import moa.streams.clustering.ClusteringStream;

public class ClusteringSetupTab
extends JPanel {
    private ClusteringTabPanel clusteringTab;
    private String lastfile;
    private JButton buttonExport;
    private JButton buttonExportSettings;
    private JButton buttonImportSettings;
    private JButton buttonStart;
    private JButton buttonStop;
    private JButton buttonWeka;
    private ClusteringAlgoPanel clusteringAlgoPanel0;
    private ClusteringAlgoPanel clusteringAlgoPanel1;
    private ClusteringEvalPanel clusteringEvalPanel1;
    private JCheckBox enableCompAlgo;
    private TextViewerPanel logPanel;

    public ClusteringSetupTab() {
        this.initComponents();
        this.clusteringAlgoPanel0.renderAlgoPanel(false);
        this.clusteringAlgoPanel1.renderAlgoPanel(true);
    }

    public AbstractClusterer getClusterer0() {
        return this.clusteringAlgoPanel0.getClusterer();
    }

    public AbstractClusterer getClusterer1() {
        if (!this.clusteringAlgoPanel1.duplicateClusterer()) {
            return this.clusteringAlgoPanel1.getClusterer();
        }
        return this.clusteringAlgoPanel0.getClusterer();
    }

    public boolean duplicateClusterer() {
        return this.clusteringAlgoPanel1.duplicateClusterer();
    }

    public ClusteringStream getStream0() {
        return this.clusteringAlgoPanel0.getStream();
    }

    public MeasureCollection[] getMeasures() {
        return this.clusteringEvalPanel1.getSelectedMeasures();
    }

    public ClusteringStream getStream1() {
        if (!this.clusteringAlgoPanel1.duplicateStream()) {
            return this.clusteringAlgoPanel1.getStream();
        }
        return this.clusteringAlgoPanel0.getStream();
    }

    public boolean duplicateStream() {
        return this.clusteringAlgoPanel1.duplicateStream();
    }

    public TextViewerPanel getLogPanel() {
        return this.logPanel;
    }

    public void addButtonActionListener(ActionListener l) {
        this.buttonWeka.addActionListener(l);
        this.buttonWeka.setActionCommand("weka export");
        this.buttonExport.addActionListener(l);
        this.buttonExport.setActionCommand("csv export");
    }

    private void initComponents() {
        this.clusteringAlgoPanel0 = new ClusteringAlgoPanel();
        this.enableCompAlgo = new JCheckBox();
        this.clusteringAlgoPanel1 = new ClusteringAlgoPanel();
        this.clusteringEvalPanel1 = new ClusteringEvalPanel();
        this.buttonStart = new JButton();
        this.buttonStop = new JButton();
        this.buttonExport = new JButton();
        this.buttonWeka = new JButton();
        this.buttonImportSettings = new JButton();
        this.buttonExportSettings = new JButton();
        this.logPanel = new TextViewerPanel();
        this.setLayout(new GridBagLayout());
        this.clusteringAlgoPanel0.setPreferredSize(new Dimension(300, 60));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.clusteringAlgoPanel0, gridBagConstraints);
        this.enableCompAlgo.setSelected(true);
        this.enableCompAlgo.setText("use Comparison-Algorithm for visualization");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(21, 4, 0, 4);
        this.add((Component)this.enableCompAlgo, gridBagConstraints);
        this.clusteringAlgoPanel1.setPreferredSize(new Dimension(350, 150));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.clusteringAlgoPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.clusteringEvalPanel1, gridBagConstraints);
        this.buttonStart.setText("Start");
        this.buttonStart.setPreferredSize(new Dimension(80, 23));
        this.buttonStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringSetupTab.this.buttonStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonStart, gridBagConstraints);
        this.buttonStop.setText("Stop");
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringSetupTab.this.buttonStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonStop, gridBagConstraints);
        this.buttonExport.setText("Export CSV");
        this.buttonExport.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonExport, gridBagConstraints);
        this.buttonWeka.setText("Weka Explorer");
        this.buttonWeka.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonWeka, gridBagConstraints);
        this.buttonImportSettings.setText("Import");
        this.buttonImportSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringSetupTab.this.buttonImportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 75, 4, 4);
        this.add((Component)this.buttonImportSettings, gridBagConstraints);
        this.buttonExportSettings.setText("Export");
        this.buttonExportSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClusteringSetupTab.this.buttonExportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonExportSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.logPanel, gridBagConstraints);
    }

    private void buttonImportSettingsActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter(new FileExtensionFilter("txt"));
        if (this.lastfile != null) {
            fileChooser.setSelectedFile(new File(this.lastfile));
        }
        if (fileChooser.showOpenDialog(this.buttonImportSettings) == 0) {
            this.lastfile = fileChooser.getSelectedFile().getPath();
            this.loadOptionsFromFile(fileChooser.getSelectedFile().getPath());
        }
    }

    private void buttonExportSettingsActionPerformed(ActionEvent evt) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.clusteringAlgoPanel0.getStreamValueAsCLIString() + "\n");
        sb.append(this.clusteringAlgoPanel0.getAlgorithmValueAsCLIString() + "\n");
        if (this.clusteringAlgoPanel1.duplicateStream()) {
            sb.append("1\n");
        } else {
            sb.append(this.clusteringAlgoPanel1.getStreamValueAsCLIString() + "\n");
        }
        if (this.clusteringAlgoPanel1.duplicateClusterer()) {
            sb.append("1\n");
        } else {
            sb.append(this.clusteringAlgoPanel1.getAlgorithmValueAsCLIString() + "\n");
        }
        System.out.println(sb);
        this.logPanel.addText(sb.toString());
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.toggle(true);
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
        this.stop(true);
    }

    private void loadOptionsFromFile(String filepath) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            String stream0 = line = in.readLine();
            this.clusteringAlgoPanel0.setStreamValueAsCLIString(stream0);
            String algo0 = line = in.readLine();
            this.clusteringAlgoPanel0.setAlgorithmValueAsCLIString(algo0);
            String stream1 = line = in.readLine();
            if (stream1.startsWith("1")) {
                this.clusteringAlgoPanel1.setDuplicateStream(true);
            } else {
                this.clusteringAlgoPanel1.setStreamValueAsCLIString(stream1);
            }
            String algo1 = line = in.readLine();
            if (algo1.startsWith("1")) {
                this.clusteringAlgoPanel1.setDuplicateClusterer(true);
            } else {
                this.clusteringAlgoPanel1.setAlgorithmValueAsCLIString(algo1);
            }
            System.out.println("Loading settings from " + filepath);
            this.logPanel.addText("Loading settings from " + filepath);
        }
        catch (Exception e) {
            System.out.println("Bad option file:" + e.getMessage());
        }
    }

    void setClusteringTab(ClusteringTabPanel clusteringTab) {
        this.clusteringTab = clusteringTab;
    }

    public void toggleRunMode() {
        this.toggle(false);
    }

    public void stopRun() {
        this.stop(false);
    }

    private void toggle(boolean internal) {
        this.setStateConfigButtons(false);
        if (this.buttonStart.getText().equals("Pause")) {
            this.buttonStart.setText("Resume");
            this.buttonWeka.setEnabled(true);
            this.buttonExport.setEnabled(true);
        } else {
            this.buttonStart.setText("Pause");
            this.buttonWeka.setEnabled(false);
            this.buttonExport.setEnabled(false);
        }
        if (internal) {
            this.clusteringTab.toggle();
        }
    }

    private void stop(boolean internal) {
        this.buttonStart.setEnabled(true);
        this.buttonStart.setText("Start");
        this.buttonStop.setEnabled(false);
        this.buttonWeka.setEnabled(false);
        this.buttonExport.setEnabled(false);
        this.setStateConfigButtons(true);
        if (internal) {
            this.clusteringTab.stop();
        }
    }

    private void setStateConfigButtons(boolean state) {
        this.buttonStop.setEnabled(!state);
        this.buttonExportSettings.setEnabled(state);
        this.buttonImportSettings.setEnabled(state);
        this.enableCompAlgo.setEnabled(state);
    }
}

