/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustream;

import moa.clusterers.clustream.cern.Gamma;

public class AuxiliaryFunctions {
    public static final int GAMMA_ITERATIONS = 100;

    private AuxiliaryFunctions() {
    }

    private static double incompleteGamma(double a, double x) {
        assert (!Double.isNaN(a));
        assert (!Double.isNaN(x));
        double sum = 0.0;
        double xPow = 1.0;
        for (int n = 0; n < 100; ++n) {
            double denom = a;
            for (int i = 1; i <= n; ++i) {
                denom *= a + (double)i;
            }
            assert (denom != 0.0);
            sum += xPow / denom;
            xPow *= x;
        }
        double res = Math.pow(x, a) * Math.exp(-x) * sum;
        if (Double.isNaN(res)) {
            System.err.println("a " + a);
            System.err.println("x " + x);
            System.err.println("x^a " + Math.pow(x, a));
            System.err.println("e^-x " + Math.exp(-x));
            System.err.println("sum " + sum);
            assert (false);
        }
        return res;
    }

    public static double gammaHalf(int n) {
        int[] doubleFac = new int[]{1, 1, 2, 3, 8, 15, 48, 105, 384, 945, 3840, 10395, 46080, 135135, 645120, 0x1EEE11, 10321920, 34459425, 185794560, 654729075};
        if (n == 0) {
            return Double.POSITIVE_INFINITY;
        }
        if (n % 2 == 0) {
            int v = n / 2 - 1;
            int res = 1;
            for (int i = 1; i <= v; ++i) {
                res *= i;
            }
            return res;
        }
        if (n == 1) {
            return 1.772453850905513;
        }
        if (n == 3) {
            return 0.8862269254527603;
        }
        return Math.sqrt(Math.PI) * (double)doubleFac[n - 2] / Math.pow(2.0, (double)(n - 1) * 0.5);
    }

    public static double distanceProbabilty(double threshold, int dimension) {
        if (threshold == 0.0) {
            return 1.0;
        }
        return 1.0 - Gamma.incompleteGamma((double)dimension * 0.5, threshold * 0.5) / AuxiliaryFunctions.gammaHalf(dimension);
    }

    public static double gompertzWeight(double average, double count) {
        if (average < 2.0) {
            return 1.0;
        }
        double logT = Math.log(0.97);
        double logt = Math.log(1.0E-4);
        double denomB = Math.pow(logT * logT, 1.0 / (average - 2.0));
        double b = Math.pow(logt * logt, 1.0 / (2.0 * (1.0 - 2.0 / average))) / denomB;
        double c = -(1.0 / average) * Math.log(-(1.0 / b) * logT);
        assert (b >= 0.0) : "Bad b " + b + ", average " + average;
        assert (c >= 0.0) : "Bad c " + c + ", average " + average;
        return Math.exp(-b * Math.exp(-c * count));
    }
}

