/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree;

import moa.clusterers.clustree.ClusKernel;
import moa.clusterers.clustree.ClusTree;
import moa.clusterers.clustree.Entry;

public class Node {
    final int NUMBER_ENTRIES = 3;
    static int INSERTIONS_BETWEEN_CLEANUPS = 10000;
    private Entry[] entries;
    private int level;

    protected Node(int numberDimensions, int level) {
        this.level = level;
        this.entries = new Entry[3];
        for (int i = 0; i < 3; ++i) {
            this.entries[i] = new Entry(numberDimensions);
        }
    }

    protected Node(int numberDimensions, int numberClasses, int level, boolean fakeRoot) {
        this.level = level;
        this.entries = new Entry[3];
        for (int i = 0; i < 3; ++i) {
            this.entries[i] = new Entry(numberDimensions);
        }
    }

    protected boolean isLeaf() {
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            if (entry.getChild() == null) continue;
            return false;
        }
        return true;
    }

    protected Entry nearestEntry(ClusKernel buffer) {
        Entry entry;
        Entry res = this.entries[0];
        double min = res.calcDistance(buffer);
        for (int i = 1; i < this.entries.length && !(entry = this.entries[i]).isEmpty(); ++i) {
            double distance = entry.calcDistance(buffer);
            if (!(distance < min)) continue;
            min = distance;
            res = entry;
        }
        return res;
    }

    protected Entry nearestEntry(Entry newEntry) {
        assert (!this.entries[0].isEmpty());
        Entry res = this.entries[0];
        double min = res.calcDistance(newEntry);
        for (int i = 1; i < this.entries.length && !this.entries[i].isEmpty(); ++i) {
            Entry entry = this.entries[i];
            double distance = entry.calcDistance(newEntry);
            if (!(distance < min)) continue;
            min = distance;
            res = entry;
        }
        return res;
    }

    protected int numFreeEntries() {
        int res = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            if (!entry.isEmpty()) continue;
            ++res;
        }
        assert (3 == this.entries.length);
        return res;
    }

    protected void addEntry(Entry newEntry, long currentTime) {
        int freePosition = this.getNextEmptyPosition();
        this.entries[freePosition].initializeEntry(newEntry, currentTime);
    }

    private int getNextEmptyPosition() {
        Entry e;
        int counter;
        for (counter = 0; counter < this.entries.length && !(e = this.entries[counter]).isEmpty(); ++counter) {
        }
        if (counter == this.entries.length) {
            throw new RuntimeException("Entry added to a node which is already full.");
        }
        return counter;
    }

    protected Entry getIrrelevantEntry(double threshold) {
        for (int i = 0; i < this.entries.length; ++i) {
            Entry entry = this.entries[i];
            if (!entry.isIrrelevant(threshold)) continue;
            return entry;
        }
        return null;
    }

    protected Entry[] getEntries() {
        return this.entries;
    }

    protected int getRawLevel() {
        return this.level;
    }

    protected int getLevel(ClusTree tree) {
        int numRootSplits = tree.getNumRootSplits();
        return numRootSplits - this.getRawLevel();
    }

    protected void clear() {
        for (int i = 0; i < 3; ++i) {
            this.entries[i].shallowClear();
        }
    }

    protected void mergeEntries(int pos1, int pos2) {
        assert (this.numFreeEntries() == 0);
        assert (pos1 < pos2);
        this.entries[pos1].mergeWith(this.entries[pos2]);
        for (int i = pos2; i < this.entries.length - 1; ++i) {
            this.entries[i] = this.entries[i + 1];
        }
        this.entries[this.entries.length - 1].clear();
    }

    protected void makeOlder(long currentTime, double negLambda) {
        Entry entry;
        for (int i = 0; i < this.entries.length && !(entry = this.entries[i]).isEmpty(); ++i) {
            entry.makeOlder(currentTime, negLambda);
        }
    }
}

