/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.denstream;

import java.util.ArrayList;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.denstream.MicroCluster;
import moa.clusterers.denstream.Timestamp;
import moa.core.Measurement;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.DenseInstance;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenStream
extends AbstractClusterer {
    public FloatOption epsilonOption = new FloatOption("epsilon", 'e', "Defines the epsilon neighbourhood", 0.01, 0.0, 1.0);
    public IntOption minPointsOption = new IntOption("minPoints", 'p', "Minimal number of points cluster has to contain.", 10);
    public FloatOption lambdaOption = new FloatOption("lambda", 'l', "", 0.006, 0.0, 1.0);
    public FloatOption betaOption = new FloatOption("beta", 'b', "", 0.001, 0.0, 1.0);
    public FloatOption muOption = new FloatOption("mu", 'm', "", 1.0, 0.0, Double.MAX_VALUE);
    public IntOption initPointsOption = new IntOption("initPoints", 'i', "Number of points to use for initialization.", 1000);
    double lambda;
    double epsilon;
    int minPoints;
    double mu;
    double beta;
    Clustering p_micro_cluster;
    Clustering o_micro_cluster;
    ArrayList<DenPoint> initBuffer;
    boolean initialized;
    private long timestamp = 0L;
    Timestamp currentTimestamp;
    long tp;

    @Override
    public void resetLearningImpl() {
        this.currentTimestamp = new Timestamp();
        this.lambda = this.lambdaOption.getValue();
        this.epsilon = this.epsilonOption.getValue();
        this.minPoints = this.minPointsOption.getValue();
        this.mu = this.muOption.getValue();
        this.beta = this.betaOption.getValue();
        this.initialized = false;
        this.p_micro_cluster = new Clustering();
        this.o_micro_cluster = new Clustering();
        this.initBuffer = new ArrayList();
        this.tp = Math.round(1.0 / this.lambda * Math.log(this.beta * this.mu / (this.beta * this.mu - 1.0))) + 1L;
    }

    public void initialDBScan() {
        for (int p = 0; p < this.initBuffer.size(); ++p) {
            DenPoint point = this.initBuffer.get(p);
            if (point.covered) continue;
            point.covered = true;
            ArrayList<Integer> neighbourhood = this.getNeighbourhoodIDs(point, this.initBuffer, this.epsilon);
            if (neighbourhood.size() > this.minPoints) {
                MicroCluster mc = new MicroCluster((Instance)point, point.numAttributes(), this.timestamp, this.lambda, this.currentTimestamp);
                this.expandCluster(mc, this.initBuffer, neighbourhood);
                this.p_micro_cluster.add(mc);
                continue;
            }
            point.covered = false;
        }
    }

    @Override
    public void trainOnInstanceImpl(Instance inst) {
        ++this.timestamp;
        this.currentTimestamp.setTimestamp(this.timestamp);
        DenPoint point = new DenPoint(inst, this.timestamp);
        if (!this.initialized) {
            this.initBuffer.add(point);
            if (this.initBuffer.size() >= this.initPointsOption.getValue()) {
                this.initialDBScan();
                this.initialized = true;
            }
        } else {
            MicroCluster xCopy;
            MicroCluster x;
            boolean merged = false;
            if (this.p_micro_cluster.getClustering().size() != 0) {
                x = this.nearestCluster(point, this.p_micro_cluster);
                xCopy = x.copy();
                xCopy.insert((Instance)point, this.timestamp);
                if (xCopy.getRadius(this.timestamp) <= this.epsilon) {
                    x.insert((Instance)point, this.timestamp);
                    merged = true;
                }
            }
            if (!merged && this.o_micro_cluster.getClustering().size() != 0) {
                x = this.nearestCluster(point, this.o_micro_cluster);
                xCopy = x.copy();
                xCopy.insert((Instance)point, this.timestamp);
                if (xCopy.getRadius(this.timestamp) <= this.epsilon) {
                    x.insert((Instance)point, this.timestamp);
                    merged = true;
                    if (x.getWeight() > this.beta * this.mu) {
                        this.o_micro_cluster.getClustering().remove(x);
                        this.p_micro_cluster.getClustering().add(x);
                    }
                }
            }
            if (!merged) {
                this.o_micro_cluster.getClustering().add(new MicroCluster(point.toDoubleArray(), point.toDoubleArray().length, this.timestamp, this.lambda, this.currentTimestamp));
            }
            if (this.timestamp % this.tp == 0L) {
                ArrayList<MicroCluster> removalList = new ArrayList<MicroCluster>();
                for (Cluster cluster : this.p_micro_cluster.getClustering()) {
                    if (!(((MicroCluster)cluster).getWeight() < this.beta * this.mu)) continue;
                    removalList.add((MicroCluster)cluster);
                }
                for (MicroCluster microCluster : removalList) {
                    this.p_micro_cluster.getClustering().remove(microCluster);
                }
                for (Cluster cluster : this.o_micro_cluster.getClustering()) {
                    long t0 = ((MicroCluster)cluster).getCreationTime();
                    double xsi1 = Math.pow(2.0, -this.lambda * (double)(this.timestamp - t0 + this.tp)) - 1.0;
                    double xsi2 = Math.pow(2.0, -this.lambda * (double)this.tp) - 1.0;
                    double xsi = xsi1 / xsi2;
                    if (!(((MicroCluster)cluster).getWeight() < xsi)) continue;
                    removalList.add((MicroCluster)cluster);
                }
                for (MicroCluster microCluster : removalList) {
                    this.o_micro_cluster.getClustering().remove(microCluster);
                }
            }
        }
    }

    private void expandCluster(MicroCluster mc, ArrayList<DenPoint> points, ArrayList<Integer> neighbourhood) {
        for (int p : neighbourhood) {
            DenPoint npoint = points.get(p);
            if (npoint.covered) continue;
            npoint.covered = true;
            mc.insert((Instance)npoint, this.timestamp);
            ArrayList<Integer> neighbourhood2 = this.getNeighbourhoodIDs(npoint, this.initBuffer, this.epsilon);
            if (neighbourhood.size() <= this.minPoints) continue;
            this.expandCluster(mc, points, neighbourhood2);
        }
    }

    private ArrayList<Integer> getNeighbourhoodIDs(DenPoint point, ArrayList<DenPoint> points, double eps) {
        ArrayList<Integer> neighbourIDs = new ArrayList<Integer>();
        for (int p = 0; p < points.size(); ++p) {
            double dist;
            DenPoint npoint = points.get(p);
            if (npoint.covered || !((dist = this.distance(point.toDoubleArray(), points.get(p).toDoubleArray())) < eps)) continue;
            neighbourIDs.add(p);
        }
        return neighbourIDs;
    }

    private MicroCluster nearestCluster(DenPoint p, Clustering cl) {
        MicroCluster min = null;
        double minDist = 0.0;
        for (int c = 0; c < cl.size(); ++c) {
            MicroCluster x = (MicroCluster)cl.get(c);
            if (min == null) {
                min = x;
            }
            double dist = this.distance(p.toDoubleArray(), x.getCenter());
            if (!((dist -= x.getRadius(this.timestamp)) < minDist)) continue;
            minDist = dist;
            min = x;
        }
        return min;
    }

    private double distance(double[] pointA, double[] pointB) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i];
            distance += d * d;
        }
        return Math.sqrt(distance);
    }

    @Override
    public Clustering getClusteringResult() {
        return null;
    }

    @Override
    public boolean implementsMicroClusterer() {
        return true;
    }

    @Override
    public Clustering getMicroClusteringResult() {
        return this.p_micro_cluster;
    }

    @Override
    protected Measurement[] getModelMeasurementsImpl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void getModelDescription(StringBuilder out, int indent) {
    }

    @Override
    public boolean isRandomizable() {
        return true;
    }

    @Override
    public double[] getVotesForInstance(Instance inst) {
        return null;
    }

    private class DenPoint
    extends DenseInstance {
        protected boolean covered;

        public DenPoint(Instance nextInstance, Long timestamp) {
            super(nextInstance);
            this.setDataset(nextInstance.dataset());
        }
    }
}

