/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import moa.cluster.Cluster;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticalCollection
extends MeasureCollection {
    private static final long serialVersionUID = 1L;
    protected Random instanceRandom = new Random(117L);
    private boolean debug = false;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"van Dongen", "Rand statistic", "VarInformation"};
        return names;
    }

    @Override
    protected boolean[] getDefaultEnabled() {
        boolean[] defaults = new boolean[]{false, false, false, false};
        return defaults;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) throws Exception {
        int i;
        int[][] counts = new int[trueClustering.size() + 1][clustering.size() + 1];
        int[] sumsHC = new int[trueClustering.size() + 1];
        int[] sumsFC = new int[clustering.size() + 1];
        int n = 0;
        for (int p = 0; p < points.size(); ++p) {
            DataPoint point = points.get(p);
            boolean hc_noise = true;
            for (i = 0; i < trueClustering.size() + 1; ++i) {
                boolean check = false;
                if (i < trueClustering.size()) {
                    Cluster hc = trueClustering.get(i);
                    if (hc.getInclusionProbability((Instance)point) >= 1.0) {
                        check = true;
                        hc_noise = false;
                    }
                } else if (hc_noise) {
                    check = true;
                }
                if (!check) continue;
                boolean fc_noise = true;
                for (int j = 0; j < clustering.size() + 1; ++j) {
                    if (j < clustering.size()) {
                        Cluster fc = clustering.get(j);
                        if (!(fc.getInclusionProbability((Instance)point) >= 1.0)) continue;
                        int[] nArray = counts[i];
                        int n2 = j;
                        nArray[n2] = nArray[n2] + 1;
                        int n3 = j;
                        sumsFC[n3] = sumsFC[n3] + 1;
                        int n4 = i;
                        sumsHC[n4] = sumsHC[n4] + 1;
                        ++n;
                        fc_noise = false;
                        continue;
                    }
                    if (!fc_noise) continue;
                    int[] nArray = counts[i];
                    int n5 = j;
                    nArray[n5] = nArray[n5] + 1;
                    int n6 = j;
                    sumsFC[n6] = sumsFC[n6] + 1;
                    int n7 = i;
                    sumsHC[n7] = sumsHC[n7] + 1;
                    ++n;
                }
            }
        }
        if (this.debug) {
            for (int i2 = 0; i2 < counts.length; ++i2) {
                System.out.println("Con " + i2 + ": " + Arrays.toString(counts[i2]));
            }
            System.out.println("Sum FC" + Arrays.toString(sumsFC));
            System.out.println("Sum HC" + Arrays.toString(sumsHC));
        }
        double mutual = 0.0;
        for (int j = 0; j < clustering.size() + 1; ++j) {
            for (i = 0; i < trueClustering.size() + 1; ++i) {
                if (counts[i][j] == 0) continue;
                double m = (double)counts[i][j] / (double)n * Math.log((double)counts[i][j] / (double)sumsFC[j] / (double)sumsHC[i] * (double)n);
                if (this.debug) {
                    System.out.println("(" + i + "/" + j + "): " + m);
                }
                mutual += m;
            }
        }
        double mutualraw = mutual;
        double varInfo = 0.0;
        double varInfoFC = 0.0;
        for (int j = 0; j < clustering.size() + 1; ++j) {
            if (sumsFC[j] == 0) continue;
            varInfoFC += (double)sumsFC[j] / (double)n * Math.log((double)sumsFC[j] / (double)n);
        }
        double varInfoHC = 0.0;
        for (int i3 = 0; i3 < trueClustering.size() + 1; ++i3) {
            if (sumsHC[i3] == 0) continue;
            varInfoHC += (double)sumsHC[i3] / (double)n * Math.log((double)sumsHC[i3] / (double)n);
        }
        if (this.debug) {
            System.out.println("FC " + varInfoFC + " / HC " + varInfoHC + " / mutual " + mutual);
        }
        varInfo = Math.abs(mutualraw + varInfoFC + varInfoHC) < 1.0E-10 ? 1.0 : 2.0 * mutualraw / (-varInfoFC - varInfoHC);
        this.addValue("VarInformation", varInfo);
        double dongen = 0.0;
        double dongenMaxFC = 0.0;
        double dongenMaxSumFC = 0.0;
        for (int j = 0; j < clustering.size() + 1; ++j) {
            double max = 0.0;
            for (int i4 = 0; i4 < trueClustering.size() + 1; ++i4) {
                if (!((double)counts[i4][j] > max)) continue;
                max = counts[i4][j];
            }
            dongenMaxFC += max;
            if (!((double)sumsFC[j] > dongenMaxSumFC)) continue;
            dongenMaxSumFC = sumsFC[j];
        }
        double dongenMaxHC = 0.0;
        double dongenMaxSumHC = 0.0;
        for (int i5 = 0; i5 < trueClustering.size() + 1; ++i5) {
            double max = 0.0;
            for (int j = 0; j < clustering.size() + 1; ++j) {
                if (!((double)counts[i5][j] > max)) continue;
                max = counts[i5][j];
            }
            dongenMaxHC += max;
            if (!((double)sumsHC[i5] > dongenMaxSumHC)) continue;
            dongenMaxSumHC = sumsHC[i5];
        }
        dongen = 1.0 - ((double)(2 * n) - dongenMaxFC - dongenMaxHC) / ((double)(2 * n) - dongenMaxSumFC - dongenMaxSumHC);
        if (this.debug) {
            System.out.println("Dongen HC:" + dongenMaxHC + " FC:" + dongenMaxFC + " Total:" + dongen + " n " + n);
        }
        this.addValue("van Dongen", dongen);
        double m1 = 0.0;
        for (int i6 = 0; i6 < trueClustering.size() + 1; ++i6) {
            double v = sumsHC[i6];
            m1 += v * (v - 1.0) / 2.0;
        }
        double m2 = 0.0;
        for (int j = 0; j < clustering.size() + 1; ++j) {
            double v = sumsFC[j];
            m2 += v * (v - 1.0) / 2.0;
        }
        double m = 0.0;
        for (int i7 = 0; i7 < trueClustering.size() + 1; ++i7) {
            for (int j = 0; j < clustering.size() + 1; ++j) {
                double v = counts[i7][j];
                m += v * (v - 1.0) / 2.0;
            }
        }
        double M = (double)(n * (n - 1)) / 2.0;
        double normalizedRand = (m - m1 * m2 / M) / (m1 / 2.0 + m2 / 2.0 - m1 * m2 / M);
        this.addValue("Rand statistic", normalizedRand);
    }
}

