/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Utils;

public class WindowClassificationPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double TotalweightObserved = 0.0;
    protected int width;
    protected Estimator weightObserved;
    protected Estimator weightCorrect;

    public void setWindowWidth(int w) {
        this.width = w;
        this.reset();
    }

    public void reset() {
        this.weightCorrect = new Estimator(this.width);
        this.weightObserved = new Estimator(this.width);
        this.TotalweightObserved = 0.0;
    }

    public void addClassificationAttempt(int trueClass, double[] classVotes, double weight) {
        if (this.TotalweightObserved == 0.0) {
            this.reset();
        }
        if (weight > 0.0) {
            this.TotalweightObserved += weight;
            this.weightObserved.add(weight);
            if (Utils.maxIndex((double[])classVotes) == trueClass) {
                this.weightCorrect.add(weight);
            } else {
                this.weightCorrect.add(0.0);
            }
        }
    }

    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.TotalweightObserved), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved.total();
    }

    public double getFractionCorrectlyClassified() {
        return this.weightObserved.total() > 0.0 ? this.weightCorrect.total() / this.weightObserved.total() : 0.0;
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }

    public class Estimator {
        protected double[] window;
        protected int posWindow;
        protected int lenWindow;
        protected int SizeWindow;
        protected double sum;

        public Estimator(int sizeWindow) {
            this.window = new double[sizeWindow];
            this.SizeWindow = sizeWindow;
            this.posWindow = 0;
        }

        public void add(double value) {
            this.sum -= this.window[this.posWindow];
            this.sum += value;
            this.window[this.posWindow] = value;
            ++this.posWindow;
            if (this.posWindow == this.SizeWindow) {
                this.posWindow = 0;
            }
        }

        public double total() {
            return this.sum;
        }
    }
}

