/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.clustertab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.Clusterer;
import moa.gui.GUIUtils;
import moa.gui.OptionEditComponent;
import moa.options.AbstractOption;
import moa.options.ClassOption;
import moa.options.FlagOption;
import moa.options.Option;
import moa.streams.clustering.ClusteringStream;

public class ClusteringAlgoPanel
extends JPanel {
    protected List<OptionEditComponent> editComponents = new LinkedList<OptionEditComponent>();
    private ClassOption streamOption = new ClassOption("Stream", 's', "Stream to learn from.", ClusteringStream.class, "RandomRBFGeneratorEvents");
    private ClassOption algorithmOption = new ClassOption("Algorithm", 'a', "Algorithm to use.", Clusterer.class, "ClusterGenerator");
    private FlagOption sameStreamOption = new FlagOption("duplicateStream", 'S', "Same as above");
    private FlagOption sameAlgoOption = new FlagOption("duplicateAlgorithm", 'A', "Same as above");
    private boolean secondAlgorithm = false;
    private JFrame optionsFrame;

    public void renderAlgoPanel(boolean secondAlgorithm) {
        this.secondAlgorithm = secondAlgorithm;
        this.setLayout(new BorderLayout());
        ArrayList<AbstractOption> options = new ArrayList<AbstractOption>();
        options.add(this.streamOption);
        if (secondAlgorithm) {
            options.add(this.sameStreamOption);
        }
        options.add(this.algorithmOption);
        if (secondAlgorithm) {
            options.add(this.sameAlgoOption);
        }
        JPanel optionsPanel = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        optionsPanel.setLayout(gbLayout);
        for (int i = 0; i < options.size(); ++i) {
            JLabel label = new JLabel(((Option)options.get(i)).getName());
            label.setToolTipText(((Option)options.get(i)).getPurpose());
            gbc.gridx = 0;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            optionsPanel.add((Component)label, gbc);
            JComponent editor = ((Option)options.get(i)).getEditComponent();
            label.setLabelFor(editor);
            this.editComponents.add((OptionEditComponent)((Object)editor));
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.anchor = 10;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(5, 5, 5, 5);
            optionsPanel.add((Component)editor, gbc);
        }
        if (secondAlgorithm) {
            this.setPanelTitle("Cluster Comparison-Algorithm Setup");
        }
        this.add(optionsPanel);
    }

    public AbstractClusterer getClusterer() {
        AbstractClusterer c = null;
        this.applyChanges();
        try {
            c = (AbstractClusterer)ClassOption.cliStringToObject(this.algorithmOption.getValueAsCLIString(), Clusterer.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(ClusteringAlgoPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return c;
    }

    public boolean duplicateClusterer() {
        this.applyChanges();
        return this.sameAlgoOption.isSet();
    }

    public ClusteringStream getStream() {
        ClusteringStream s = null;
        this.applyChanges();
        try {
            s = (ClusteringStream)ClassOption.cliStringToObject(this.streamOption.getValueAsCLIString(), ClusteringStream.class, null);
        }
        catch (Exception ex) {
            Logger.getLogger(ClusteringAlgoPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        return s;
    }

    public boolean duplicateStream() {
        this.applyChanges();
        return this.sameStreamOption.isSet();
    }

    public String getStreamValueAsCLIString() {
        this.applyChanges();
        return this.streamOption.getValueAsCLIString();
    }

    public String getAlgorithmValueAsCLIString() {
        this.applyChanges();
        return this.algorithmOption.getValueAsCLIString();
    }

    public void setStreamValueAsCLIString(String s) {
        this.streamOption.setValueViaCLIString(s);
        int index = 0;
        this.editComponents.get(index).setEditState(this.streamOption.getValueAsCLIString());
    }

    public void setAlgorithmValueAsCLIString(String s) {
        this.algorithmOption.setValueViaCLIString(s);
        int index = this.secondAlgorithm ? 2 : 1;
        this.editComponents.get(index).setEditState(this.algorithmOption.getValueAsCLIString());
    }

    public void setDuplicateStream(boolean state) {
        if (this.secondAlgorithm) {
            this.sameStreamOption.setValue(state);
            this.editComponents.get(1).setEditState(this.sameStreamOption.getValueAsCLIString());
        }
    }

    public void setDuplicateClusterer(boolean state) {
        if (this.secondAlgorithm) {
            this.sameAlgoOption.setValue(state);
            this.editComponents.get(3).setEditState(this.sameAlgoOption.getValueAsCLIString());
        }
    }

    public void applyChanges() {
        for (OptionEditComponent editor : this.editComponents) {
            try {
                editor.applyState();
            }
            catch (Exception ex) {
                GUIUtils.showExceptionDialog(this, "Problem with option " + editor.getEditedOption().getName(), ex);
            }
        }
    }

    public void setPanelTitle(String title) {
        this.setBorder(BorderFactory.createTitledBorder(null, title, 0, 0, new Font("Tahoma", 1, 11)));
    }

    private void initComponents() {
        this.optionsFrame = new JFrame();
        this.setBorder(BorderFactory.createTitledBorder(null, "Cluster Algorithm Setup", 0, 0, new Font("Tahoma", 1, 11)));
        this.setLayout(new GridBagLayout());
    }
}

