/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import moa.clusterers.AbstractClusterer;
import moa.core.ObjectRepository;
import moa.evaluation.LearningCurve;
import moa.gui.visualization.BatchCmd;
import moa.options.ClassOption;
import moa.options.FileOption;
import moa.options.IntOption;
import moa.streams.clustering.RandomRBFGeneratorEvents;
import moa.tasks.MainTask;
import moa.tasks.TaskMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateClustering
extends MainTask {
    private static final long serialVersionUID = 1L;
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Clusterer to train.", AbstractClusterer.class, "clustream.Clustream");
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to learn from.", RandomRBFGeneratorEvents.class, "RandomRBFGeneratorEvents");
    public IntOption instanceLimitOption = new IntOption("instanceLimit", 'i', "Maximum number of instances to test/train on  (-1 = no limit).", 100000, -1, Integer.MAX_VALUE);
    public IntOption measureCollectionTypeOption = new IntOption("measureCollectionType", 'm', "Type of measure collection", 0, 0, Integer.MAX_VALUE);
    public FileOption outputFileOption = new FileOption("outputFile", 'd', "File to output intermediate csv results to.", "outputClustering.csv", "csv", true);

    @Override
    public String getPurposeString() {
        return "Evaluates a clusterer on a stream by testing then training with each example in sequence.";
    }

    @Override
    public Class<?> getTaskResultType() {
        return LearningCurve.class;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        BatchCmd.runBatch((RandomRBFGeneratorEvents)this.getPreparedClassOption(this.streamOption), (AbstractClusterer)this.getPreparedClassOption(this.learnerOption), this.measureCollectionTypeOption.getValue(), this.instanceLimitOption.getValue(), this.outputFileOption.getValue());
        LearningCurve learningCurve = new LearningCurve("learning evaluation instances");
        return learningCurve;
    }
}

