/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.InstanceStream;
import moa.streams.generators.LEDGenerator;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MOAUtils;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.DataGenerator;

public class MOA
extends ClassificationGenerator {
    private static final long serialVersionUID = 13533833825026962L;
    protected InstanceStream m_ActualGenerator = new LEDGenerator();
    protected ClassOption m_Generator = new ClassOption("InstanceStream", 'B', "The MOA instance stream generator to use from within WEKA.", InstanceStream.class, this.m_ActualGenerator.getClass().getName());

    public String globalInfo() {
        return "A wrapper around MOA instance streams.";
    }

    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.add(new Option("\tThe MOA stream generator.\n\t(default: " + MOAUtils.toCommandLine(new LEDGenerator()) + ")", "B", 1, "-B <classname + options>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'B', (String[])options);
        ClassOption option = (ClassOption)this.m_Generator.copy();
        if (tmpStr.length() == 0) {
            option.setCurrentObject(new LEDGenerator());
        } else {
            option.setCurrentObject(MOAUtils.fromCommandLine(this.m_Generator, tmpStr));
        }
        this.setGenerator(option);
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-B");
        result.add(MOAUtils.toCommandLine(this.m_ActualGenerator));
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setGenerator(ClassOption value) {
        this.m_Generator = value;
        this.m_ActualGenerator = (InstanceStream)MOAUtils.fromOption(this.m_Generator);
    }

    public ClassOption getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The MOA stream generator to use.";
    }

    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    public Instances defineDataFormat() throws Exception {
        this.m_ActualGenerator = (InstanceStream)MOAUtils.fromOption(this.m_Generator);
        ((AbstractOptionHandler)((Object)this.m_ActualGenerator)).prepareForUse();
        this.m_DatasetFormat = new Instances((Instances)this.m_ActualGenerator.getHeader());
        int numExamples = this.getNumExamples();
        if (this.m_ActualGenerator.estimatedRemainingInstances() != -1L && this.m_ActualGenerator.estimatedRemainingInstances() < (long)numExamples) {
            numExamples = (int)this.m_ActualGenerator.estimatedRemainingInstances();
        }
        this.setNumExamplesAct(numExamples);
        return this.m_DatasetFormat;
    }

    public Instance generateExample() throws Exception {
        if (this.m_ActualGenerator.hasMoreInstances()) {
            return this.m_ActualGenerator.nextInstance();
        }
        return null;
    }

    public Instances generateExamples() throws Exception {
        Instance inst;
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        for (int i = 0; i < this.getNumExamplesAct() && (inst = this.generateExample()) != null; ++i) {
            result.add(inst);
        }
        return result;
    }

    public String generateStart() {
        return "";
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 7 $");
    }

    public static void main(String[] args) {
        MOA.runDataGenerator((DataGenerator)new MOA(), (String[])args);
    }
}

