/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.Arrays;
import java.util.Random;
import moa.cluster.Clustering;
import moa.cluster.SphereCluster;

public class ClusterGenerator {
    private static double err_intervall_width = 0.0;

    public static Clustering shiftClustering(Clustering clustering, double errorLevel, Random random) {
        int i;
        double errLevelRadiusDecrease = 0.0;
        double errLevelRadiusIncrease = 0.0;
        double errLevelPosition = 0.0;
        Clustering err_clusters = new Clustering();
        int numCluster = clustering.size();
        double[] err_seeds = new double[numCluster];
        double err_seed_sum = 0.0;
        for (int i2 = 0; i2 < numCluster; ++i2) {
            double tmp_seed = random.nextDouble();
            err_seeds[i2] = err_seed_sum + tmp_seed;
            err_seed_sum += tmp_seed;
        }
        int sumWeight = 0;
        for (i = 0; i < numCluster; ++i) {
            sumWeight = (int)((double)sumWeight + clustering.get(i).getWeight());
        }
        for (i = 0; i < numCluster; ++i) {
            double errOffset;
            if (!(clustering.get(i) instanceof SphereCluster)) {
                System.out.println("Not a Sphere Cluster");
                continue;
            }
            SphereCluster sourceCluster = (SphereCluster)clustering.get(i);
            double[] center = Arrays.copyOf(sourceCluster.getCenter(), sourceCluster.getCenter().length);
            double weight = sourceCluster.getWeight();
            double radius = sourceCluster.getRadius();
            if (errLevelPosition > 0.0) {
                int d;
                errOffset = random.nextDouble() * err_intervall_width / 2.0;
                double errOffsetDirection = random.nextBoolean() ? 1 : -1;
                double level = errLevelPosition + errOffsetDirection * errOffset;
                double[] vector = new double[center.length];
                double vectorLength = 0.0;
                for (int d2 = 0; d2 < center.length; ++d2) {
                    vector[d2] = (double)(random.nextBoolean() ? 1 : -1) * random.nextDouble();
                    vectorLength += Math.pow(vector[d2], 2.0);
                }
                vectorLength = Math.sqrt(vectorLength);
                double length = 2.0 * radius * level;
                for (int d3 = 0; d3 < center.length; ++d3) {
                    vector[d3] = vector[d3] / vectorLength * length;
                }
                double[] newCenter = new double[center.length];
                for (d = 0; d < center.length; ++d) {
                    newCenter[d] = center[d] + vector[d] >= 0.0 && center[d] + vector[d] <= 1.0 ? center[d] + vector[d] : center[d] + -1.0 * vector[d];
                }
                center = newCenter;
                for (d = 0; d < center.length; ++d) {
                    if (center[d] + vector[d] >= 0.0 && center[d] + vector[d] <= 1.0) continue;
                    System.out.println("This shouldnt have happend, Cluster center out of bounds");
                }
            }
            if (errLevelRadiusDecrease > 0.0 || errLevelRadiusIncrease > 0.0) {
                double level;
                int errOffsetDirection;
                errOffset = random.nextDouble() * err_intervall_width / 2.0;
                int n = errOffsetDirection = random.nextBoolean() ? 1 : -1;
                if (errLevelRadiusDecrease > 0.0 && (errLevelRadiusIncrease == 0.0 || random.nextBoolean())) {
                    level = errLevelRadiusDecrease + (double)errOffsetDirection * errOffset;
                    level = level < 0.0 ? 0.0 : level;
                    level = level > 1.0 ? 1.0 : level;
                    radius *= 1.0 - level;
                } else {
                    level = errLevelRadiusIncrease + (double)errOffsetDirection * errOffset;
                    level = level < 0.0 ? 0.0 : level;
                    level = level > 1.0 ? 1.0 : level;
                    radius += radius * level;
                }
            }
            SphereCluster newCluster = new SphereCluster(center, radius, weight);
            newCluster.setMeasureValue("Source Cluster", "C" + sourceCluster.getId());
            err_clusters.add(newCluster);
        }
        return err_clusters;
    }
}

