/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.clustree;

import java.util.Arrays;
import moa.cluster.CFCluster;
import moa.clusterers.clustree.util.AuxiliaryFunctions;
import weka.core.Instance;

public class ClusKernel
extends CFCluster {
    public static final double EPSILON = 1.0E-8;
    public static final double MIN_VARIANCE = 1.0E-50;
    private double weightedN;

    public ClusKernel(double[] point, int dim) {
        super(point, dim);
        this.weightedN = 1.0;
    }

    protected ClusKernel(int numberDimensions) {
        super(numberDimensions);
        this.weightedN = 0.0;
    }

    protected ClusKernel(ClusKernel other) {
        super(other);
        this.weightedN = other.getWeightedN();
    }

    public void add(ClusKernel other) {
        super.add(other);
        this.weightedN += other.weightedN;
    }

    protected void aggregate(ClusKernel other, long timeDifference, double negLambda) {
        this.makeOlder(timeDifference, negLambda);
        this.add(other);
    }

    protected void makeOlder(long timeDifference, double negLambda) {
        if (timeDifference == 0L) {
            return;
        }
        double weightFactor = AuxiliaryFunctions.weight(negLambda, timeDifference);
        this.weightedN *= weightFactor;
        int i = 0;
        while (i < this.LS.length) {
            int n = i;
            this.LS[n] = this.LS[n] * weightFactor;
            int n2 = i++;
            this.SS[n2] = this.SS[n2] * weightFactor;
        }
    }

    protected double calcDistance(ClusKernel other) {
        double N1 = this.getWeightedN();
        double N2 = other.getWeightedN();
        double[] thisLS = this.LS;
        double[] otherLS = other.LS;
        double res = 0.0;
        for (int i = 0; i < thisLS.length; ++i) {
            double substracted = thisLS[i] / N1 - otherLS[i] / N2;
            res += substracted * substracted;
        }
        return res;
    }

    protected double getWeightedN() {
        return this.weightedN;
    }

    protected boolean isEmpty() {
        return this.N == 0.0;
    }

    protected void clear() {
        this.N = 0.0;
        this.weightedN = 0.0;
        Arrays.fill(this.LS, 0.0);
        Arrays.fill(this.SS, 0.0);
    }

    protected void overwriteOldCluster(ClusKernel other) {
        this.N = other.N;
        this.weightedN = other.weightedN;
        AuxiliaryFunctions.overwriteDoubleArray(this.LS, other.LS);
        AuxiliaryFunctions.overwriteDoubleArray(this.SS, other.SS);
    }

    public double getWeight() {
        return this.weightedN;
    }

    public double[] getCenter() {
        assert (!this.isEmpty());
        double[] res = new double[this.LS.length];
        double weightedSize = this.getWeightedN();
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.LS[i] / weightedSize;
        }
        return res;
    }

    public double getInclusionProbability(Instance instance) {
        double dist = this.calcNormalizedDistance(instance.toDoubleArray());
        double res = AuxiliaryFunctions.distanceProbabilty(dist, this.LS.length);
        assert (res >= 0.0 && res <= 1.0) : "Bad confidence " + res + " for" + " distance " + dist;
        return res;
    }

    public double getRadius() {
        double[] squaredVarianceVector = this.getSquaredVarianceVector();
        double componentWeight = 1.0;
        double sumOfVariances = 0.0;
        for (int i = 0; i < squaredVarianceVector.length; ++i) {
            double d = squaredVarianceVector[i];
            sumOfVariances += 1.0 * Math.sqrt(d);
        }
        return 1.6 * (sumOfVariances / (double)squaredVarianceVector.length);
    }

    public double[] getSquaredVarianceVector() {
        double[] res = new double[this.LS.length];
        for (int i = 0; i < this.LS.length; ++i) {
            double ls = this.LS[i];
            double ss = this.SS[i];
            double lsDivN = ls / this.weightedN;
            double lsDivNSquared = lsDivN * lsDivN;
            double ssDivN = ss / this.weightedN;
            res[i] = ssDivN - lsDivNSquared;
            if (!(res[i] <= 0.0)) continue;
            if (res[i] > -1.0E-8) {
                res[i] = 1.0E-100;
                continue;
            }
            assert (false) : "Bad variance " + res[i] + ", weighted N is " + this.getWeightedN();
        }
        return res;
    }

    private double calcNormalizedDistance(double[] point) {
        assert (this.LS.length == point.length);
        double N1 = this.getWeightedN();
        double[] thisLS = this.LS;
        double[] squaredVariances = this.getSquaredVarianceVector();
        double res = 0.0;
        for (int i = 0; i < thisLS.length; ++i) {
            double substracted = thisLS[i] / N1 - point[i];
            res += substracted * substracted / squaredVariances[i];
        }
        return Math.sqrt(res);
    }
}

