/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.denstream;

import moa.cluster.CFCluster;
import moa.clusterers.denstream.Timestamp;
import weka.core.Instance;

public class MicroCluster
extends CFCluster {
    private long lastEditT = -1L;
    private long creationTimestamp = -1L;
    private double lambda;
    private Timestamp currentTimestamp;

    public MicroCluster(double[] center, int dimensions, long creationTimestamp, double lambda, Timestamp currentTimestamp) {
        super(center, dimensions);
        this.creationTimestamp = creationTimestamp;
        this.lastEditT = creationTimestamp;
        this.lambda = lambda;
        this.currentTimestamp = currentTimestamp;
    }

    public MicroCluster(Instance instance, int dimensions, long timestamp, double lambda, Timestamp currentTimestamp) {
        this(instance.toDoubleArray(), dimensions, timestamp, lambda, currentTimestamp);
    }

    public void insert(Instance instance, long timestamp) {
        this.N += 1.0;
        super.setWeight(super.getWeight() + 1.0);
        this.lastEditT = timestamp;
        for (int i = 0; i < instance.numValues(); ++i) {
            int n = i;
            this.LS[n] = this.LS[n] + instance.value(i);
            int n2 = i;
            this.SS[n2] = this.SS[n2] + instance.value(i) * instance.value(i);
        }
    }

    public long getLastEditTimestamp() {
        return this.lastEditT;
    }

    private double[] calcCF2(long dt) {
        double[] cf2 = new double[this.SS.length];
        for (int i = 0; i < this.SS.length; ++i) {
            cf2[i] = Math.pow(2.0, -this.lambda * (double)dt) * this.SS[i];
        }
        return cf2;
    }

    private double[] calcCF1(long dt) {
        double[] cf1 = new double[this.LS.length];
        for (int i = 0; i < this.LS.length; ++i) {
            cf1[i] = Math.pow(2.0, -this.lambda * (double)dt) * this.LS[i];
        }
        return cf1;
    }

    public double getWeight() {
        return this.getWeight(this.currentTimestamp.getTimestamp());
    }

    private double getWeight(long timestamp) {
        long dt = timestamp - this.lastEditT;
        return this.N * Math.pow(2.0, -this.lambda * (double)dt);
    }

    public long getCreationTime() {
        return this.creationTimestamp;
    }

    public double[] getCenter() {
        return this.getCenter(this.currentTimestamp.getTimestamp());
    }

    private double[] getCenter(long timestamp) {
        long dt = timestamp - this.lastEditT;
        double w = this.getWeight(timestamp);
        double[] res = new double[this.LS.length];
        int i = 0;
        while (i < this.LS.length) {
            res[i] = this.LS[i];
            int n = i;
            res[n] = res[n] * Math.pow(2.0, -this.lambda * (double)dt);
            int n2 = i++;
            res[n2] = res[n2] / w;
        }
        return res;
    }

    public double getRadius() {
        return this.getRadius(this.currentTimestamp.getTimestamp()) * 1.6;
    }

    public double getRadius(long timestamp) {
        long dt = timestamp - this.lastEditT;
        double[] cf1 = this.calcCF1(dt);
        double[] cf2 = this.calcCF2(dt);
        double w = this.getWeight(timestamp);
        double max = 0.0;
        double sum = 0.0;
        for (int i = 0; i < this.SS.length; ++i) {
            double x1 = cf2[i] / w;
            double x2 = Math.pow(cf1[i] / w, 2.0);
            sum += x1 - x2;
            if (!(Math.sqrt(x1 - x2) > max)) continue;
            max = Math.sqrt(x1 - x2);
        }
        return max;
    }

    public MicroCluster copy() {
        MicroCluster copy = new MicroCluster((double[])this.LS.clone(), this.LS.length, this.getCreationTime(), this.lambda, this.currentTimestamp);
        copy.setWeight(this.N + 1.0);
        copy.N = this.N;
        copy.SS = (double[])this.SS.clone();
        copy.LS = (double[])this.LS.clone();
        copy.lastEditT = this.lastEditT;
        return copy;
    }

    public double getInclusionProbability(Instance instance) {
        if (this.getCenterDistance(instance) <= this.getRadius()) {
            return 1.0;
        }
        return 0.0;
    }
}

