/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Utils;

public class BasicClassificationPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double weightCorrect;

    public void reset() {
        this.weightObserved = 0.0;
        this.weightCorrect = 0.0;
    }

    public void addClassificationAttempt(int trueClass, double[] classVotes, double weight) {
        if (weight > 0.0) {
            this.weightObserved += weight;
            if (Utils.maxIndex((double[])classVotes) == trueClass) {
                this.weightCorrect += weight;
            }
        }
    }

    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getFractionCorrectlyClassified() {
        return this.weightObserved > 0.0 ? this.weightCorrect / this.weightObserved : 0.0;
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }
}

