/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import moa.cluster.Clustering;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class F1
extends MeasureCollection {
    private static final long serialVersionUID = 1L;
    private final double pointInclusionProbThreshold = 0.5;

    @Override
    protected String[] getNames() {
        String[] names = new String[]{"Precision", "Recall", "F1"};
        return names;
    }

    @Override
    public void evaluateClustering(Clustering clustering, Clustering trueClustering, ArrayList<DataPoint> points) {
        if (clustering.size() < 0) {
            this.addValue(0, 0.0);
            this.addValue(1, 0.0);
            this.addValue(2, 0.0);
            return;
        }
        HashMap<Integer, Integer> labelMap = new HashMap<Integer, Integer>();
        int numGTCluster = trueClustering.size();
        for (int c = 0; c < numGTCluster; ++c) {
            labelMap.put((int)trueClustering.get(c).getGroundTruth(), c);
        }
        ArrayList[] foundClusters = new ArrayList[clustering.size()];
        for (int i = 0; i < foundClusters.length; ++i) {
            foundClusters[i] = new ArrayList();
        }
        int[][] classWeightsFoundClusters = new int[clustering.size()][numGTCluster];
        int[] classWeightsHidden = new int[numGTCluster];
        for (int p = 0; p < points.size(); ++p) {
            int worklabel = -1;
            if (points.get(p).classValue() != -1.0) {
                worklabel = (Integer)labelMap.get((int)points.get(p).classValue());
            }
            for (int c = 0; c < clustering.size(); ++c) {
                double prob = clustering.get(c).getInclusionProbability((Instance)points.get(p));
                if (!(prob >= 0.5)) continue;
                foundClusters[c].add(p);
                if (worklabel == -1) continue;
                int[] nArray = classWeightsFoundClusters[c];
                int n = worklabel;
                nArray[n] = nArray[n] + 1;
            }
            if (worklabel == -1) continue;
            int n = worklabel;
            classWeightsHidden[n] = classWeightsHidden[n] + 1;
        }
        double[] precision = new double[clustering.size()];
        double[] recall = new double[clustering.size()];
        double[] f1 = new double[clustering.size()];
        double F12 = 0.0;
        double precisionTotal = 0.0;
        double recallTotal = 0.0;
        int realClusters = 0;
        for (int i = 0; i < clustering.size(); ++i) {
            int max_weight = 0;
            int max_weight_index = -1;
            int cluster_weight = 0;
            for (int j = 0; j < numGTCluster; ++j) {
                if (classWeightsFoundClusters[i][j] > max_weight) {
                    max_weight = classWeightsFoundClusters[i][j];
                    max_weight_index = j;
                }
                cluster_weight += classWeightsFoundClusters[i][j];
            }
            if (max_weight_index == -1) continue;
            ++realClusters;
            precision[i] = (double)classWeightsFoundClusters[i][max_weight_index] / (double)cluster_weight;
            recall[i] = (double)classWeightsFoundClusters[i][max_weight_index] / (double)classWeightsHidden[max_weight_index];
            if (precision[i] > 0.0 || recall[i] > 0.0) {
                f1[i] = 2.0 * precision[i] * recall[i] / (precision[i] + recall[i]);
            }
            clustering.get(i).setMeasureValue("Precision", Double.toString(precision[i]));
            clustering.get(i).setMeasureValue("Recall", Double.toString(recall[i]));
            clustering.get(i).setMeasureValue("F1", Double.toString(f1[i]));
            precisionTotal += precision[i];
            recallTotal += recall[i];
            F12 += f1[i];
        }
        if (realClusters > 0) {
            F12 /= (double)realClusters;
            recallTotal /= (double)realClusters;
            precisionTotal /= (double)realClusters;
        }
        this.addValue("F1", F12);
        this.addValue("Precision", precisionTotal);
        this.addValue("Recall", recallTotal);
    }
}

