/*
 * Decompiled with CFR 0.152.
 */
package moa.evaluation;

import moa.AbstractMOAObject;
import moa.core.Measurement;
import moa.evaluation.ClassificationPerformanceEvaluator;
import weka.core.Utils;

public class BasicClassificationPerformanceEvaluator
extends AbstractMOAObject
implements ClassificationPerformanceEvaluator {
    private static final long serialVersionUID = 1L;
    protected double weightObserved;
    protected double weightCorrect;
    protected double[] columnKappa;
    protected double[] rowKappa;
    protected int numClasses;

    public void reset() {
        this.reset(this.numClasses);
    }

    public void reset(int numClasses) {
        this.numClasses = numClasses;
        this.rowKappa = new double[numClasses];
        this.columnKappa = new double[numClasses];
        for (int i = 0; i < this.numClasses; ++i) {
            this.rowKappa[i] = 0.0;
            this.columnKappa[i] = 0.0;
        }
        this.weightObserved = 0.0;
        this.weightCorrect = 0.0;
    }

    public void addClassificationAttempt(int trueClass, double[] classVotes, double weight) {
        if (weight > 0.0) {
            if (this.weightObserved == 0.0) {
                this.reset(classVotes.length > 1 ? classVotes.length : 2);
            }
            this.weightObserved += weight;
            int predictedClass = Utils.maxIndex((double[])classVotes);
            if (predictedClass == trueClass) {
                this.weightCorrect += weight;
            }
            int n = predictedClass;
            this.rowKappa[n] = this.rowKappa[n] + weight;
            int n2 = trueClass;
            this.columnKappa[n2] = this.columnKappa[n2] + weight;
        }
    }

    public Measurement[] getPerformanceMeasurements() {
        return new Measurement[]{new Measurement("classified instances", this.getTotalWeightObserved()), new Measurement("classifications correct (percent)", this.getFractionCorrectlyClassified() * 100.0), new Measurement("Kappa Statistic (percent)", this.getKappaStatistic() * 100.0)};
    }

    public double getTotalWeightObserved() {
        return this.weightObserved;
    }

    public double getFractionCorrectlyClassified() {
        return this.weightObserved > 0.0 ? this.weightCorrect / this.weightObserved : 0.0;
    }

    public double getFractionIncorrectlyClassified() {
        return 1.0 - this.getFractionCorrectlyClassified();
    }

    public double getKappaStatistic() {
        if (this.weightObserved > 0.0) {
            double p0 = this.getFractionCorrectlyClassified();
            double pc = 0.0;
            for (int i = 0; i < this.numClasses; ++i) {
                pc += this.rowKappa[i] / this.weightObserved * (this.columnKappa[i] / this.weightObserved);
            }
            return (p0 - pc) / (1.0 - pc);
        }
        return 0.0;
    }

    public void getDescription(StringBuilder sb, int indent) {
        Measurement.getMeasurementsDescription(this.getPerformanceMeasurements(), sb, indent);
    }
}

