/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import moa.clusterers.CobWeb;
import moa.options.ClassOption;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.UpdateableClusterer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MOAUtils;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class MOA
extends AbstractClusterer
implements UpdateableClusterer,
OptionHandler {
    private static final long serialVersionUID = 2605797948130310166L;
    protected moa.clusterers.Clusterer m_ActualClusterer = new CobWeb();
    protected ClassOption m_Clusterer = new ClassOption("clusterer", 'B', "The MOA clusterer to use from within WEKA.", moa.clusterers.Clusterer.class, this.m_ActualClusterer.getClass().getName().replace("moa.clusterers.", ""), this.m_ActualClusterer.getClass().getName());

    public String globalInfo() {
        return "Wrapper for MOA clusterers.\n\nSince MOA doesn't offer a mechanism to query a clusterer for the types of attributes and classes it can handle, the capabilities of this wrapper are hard-coded: nominal and numeric attributes are allowed.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe MOA clusterer to use.\n\t(default: " + MOAUtils.toCommandLine(new CobWeb()) + ")", "B", 1, "-B <classname + options>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'B', (String[])options);
        ClassOption option = (ClassOption)this.m_Clusterer.copy();
        if (tmpStr.length() == 0) {
            option.setCurrentObject(new CobWeb());
        } else {
            option.setCurrentObject(MOAUtils.fromCommandLine(this.m_Clusterer, tmpStr));
        }
        this.setClusterer(option);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-B");
        result.add(MOAUtils.toCommandLine(this.m_ActualClusterer));
        return result.toArray(new String[result.size()]);
    }

    public void setClusterer(ClassOption value) {
        this.m_Clusterer = value;
        this.m_ActualClusterer = (moa.clusterers.Clusterer)MOAUtils.fromOption(this.m_Clusterer);
    }

    public ClassOption getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The MOA clusterer to use.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public void buildClusterer(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        this.m_ActualClusterer = (moa.clusterers.Clusterer)MOAUtils.fromOption(this.m_Clusterer);
        for (int i = 0; i < data.numInstances(); ++i) {
            this.updateClusterer(data.instance(i));
        }
        this.updateFinished();
    }

    public void updateClusterer(Instance instance) throws Exception {
        this.m_ActualClusterer.trainOnInstance(instance);
    }

    public void updateFinished() {
    }

    public int numberOfClusters() throws Exception {
        int result;
        try {
            result = this.m_ActualClusterer.getClusteringResult().dimension();
        }
        catch (UnsupportedOperationException e) {
            result = 0;
        }
        catch (NullPointerException e) {
            result = 0;
        }
        catch (Exception e) {
            throw e;
        }
        return result;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] result = this.m_ActualClusterer.getVotesForInstance(instance);
        try {
            Utils.normalize((double[])result);
        }
        catch (Exception e) {
            result = new double[instance.numClasses()];
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 27 $");
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        this.m_ActualClusterer.getDescription(result, 0);
        return result.toString();
    }

    public static void main(String[] args) {
        MOA.runClusterer((Clusterer)new MOA(), (String[])args);
    }
}

