/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import moa.classifiers.HoeffdingOptionTree;
import moa.classifiers.HoeffdingOptionTreeNB;
import moa.classifiers.NaiveBayes;
import weka.core.Instance;
import weka.core.Utils;

public class HoeffdingOptionTreeNBAdaptive
extends HoeffdingOptionTreeNB {
    private static final long serialVersionUID = 1L;

    protected HoeffdingOptionTree.LearningNode newLearningNode(double[] initialClassObservations) {
        return new LearningNodeNBAdaptive(initialClassObservations);
    }

    public static class LearningNodeNBAdaptive
    extends HoeffdingOptionTreeNB.LearningNodeNB {
        private static final long serialVersionUID = 1L;
        protected double mcCorrectWeight = 0.0;
        protected double nbCorrectWeight = 0.0;

        public LearningNodeNBAdaptive(double[] initialClassObservations) {
            super(initialClassObservations);
        }

        public void learnFromInstance(Instance inst, HoeffdingOptionTree hot) {
            int trueClass = (int)inst.classValue();
            if (this.observedClassDistribution.maxIndex() == trueClass) {
                this.mcCorrectWeight += inst.weight();
            }
            if (Utils.maxIndex((double[])NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers)) == trueClass) {
                this.nbCorrectWeight += inst.weight();
            }
            super.learnFromInstance(inst, hot);
        }

        public double[] getClassVotes(Instance inst, HoeffdingOptionTree ht) {
            if (this.mcCorrectWeight > this.nbCorrectWeight) {
                return this.observedClassDistribution.getArrayCopy();
            }
            return NaiveBayes.doNaiveBayesPrediction(inst, this.observedClassDistribution, this.attributeObservers);
        }
    }
}

