/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.Arrays;
import moa.cluster.SphereCluster;
import weka.core.Instance;

public abstract class CFCluster
extends SphereCluster {
    public double N;
    public double[] LS;
    public double[] SS;

    public CFCluster(Instance instance, int dimensions) {
        this(instance.toDoubleArray(), dimensions);
    }

    protected CFCluster(int dimensions) {
        this.N = 0.0;
        this.LS = new double[dimensions];
        this.SS = new double[dimensions];
        Arrays.fill(this.LS, 0.0);
        Arrays.fill(this.SS, 0.0);
    }

    public CFCluster(double[] center, int dimensions) {
        this.N = 1.0;
        this.LS = center;
        this.SS = new double[dimensions];
        for (int i = 0; i < this.SS.length; ++i) {
            this.SS[i] = Math.pow(center[i], 2.0);
        }
    }

    public CFCluster(CFCluster cluster) {
        this.N = cluster.N;
        this.LS = Arrays.copyOf(cluster.LS, cluster.LS.length);
        this.SS = Arrays.copyOf(cluster.SS, cluster.SS.length);
    }

    public void add(CFCluster cluster) {
        this.N += cluster.N;
        CFCluster.addVectors(this.LS, cluster.LS);
        CFCluster.addVectors(this.SS, cluster.SS);
    }

    public abstract CFCluster getCF();

    public double[] getCenter() {
        assert (this.N > 0.0);
        double[] res = new double[this.LS.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.LS[i] / this.N;
        }
        return res;
    }

    public abstract double getInclusionProbability(Instance var1);

    public abstract double getRadius();

    public double getWeight() {
        return this.N;
    }

    public void setN(double N) {
        this.N = N;
    }

    public static void addVectors(double[] a1, double[] a2) {
        assert (a1 != null);
        assert (a2 != null);
        assert (a1.length == a2.length) : "Adding two arrays of different length";
        for (int i = 0; i < a1.length; ++i) {
            int n = i;
            a1[n] = a1[n] + a2[i];
        }
    }
}

