/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class SEAGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public IntOption functionOption = new IntOption("function", 'f', "Classification function used, as defined in the original paper.", 1, 1, 4);
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption balanceClassesOption = new FlagOption("balanceClasses", 'b', "Balance the number of instances of each class.");
    public IntOption numInstancesConcept = new IntOption("numInstancesConcept", 'n', "The number of instances for each concept.", 0, 0, Integer.MAX_VALUE);
    public IntOption noisePercentageOption = new IntOption("noisePercentage", 'n', "Percentage of noise to add to the data.", 10, 0, 100);
    protected static ClassFunction[] classificationFunctions = new ClassFunction[]{new ClassFunction(){

        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 8.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 9.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 7.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        public int determineClass(double attrib1, double attrib2, double attrib3) {
            return attrib1 + attrib2 <= 9.5 ? 0 : 1;
        }
    }};
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;
    protected boolean nextClassShouldBeZero;

    public String getPurposeString() {
        return "Generates SEA concepts functions.";
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector attributes = new FastVector();
        attributes.addElement((Object)new Attribute("attrib1"));
        attributes.addElement((Object)new Attribute("attrib2"));
        attributes.addElement((Object)new Attribute("attrib3"));
        FastVector classLabels = new FastVector();
        classLabels.addElement((Object)"groupA");
        classLabels.addElement((Object)"groupB");
        attributes.addElement((Object)new Attribute("class", (List)classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), (ArrayList)attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public Instance nextInstance() {
        double attrib1 = 0.0;
        double attrib2 = 0.0;
        double attrib3 = 0.0;
        int group = 0;
        boolean desiredClassFound = false;
        while (!desiredClassFound) {
            attrib1 = 10.0 * this.instanceRandom.nextDouble();
            attrib2 = 10.0 * this.instanceRandom.nextDouble();
            attrib3 = 10.0 * this.instanceRandom.nextDouble();
            group = classificationFunctions[this.functionOption.getValue() - 1].determineClass(attrib1, attrib2, attrib3);
            if (!this.balanceClassesOption.isSet()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.nextClassShouldBeZero || group != 0) && (this.nextClassShouldBeZero || group != 1)) continue;
            desiredClassFound = true;
            this.nextClassShouldBeZero = !this.nextClassShouldBeZero;
        }
        if (1 + this.instanceRandom.nextInt(100) <= this.noisePercentageOption.getValue()) {
            group = group == 0 ? 1 : 0;
        }
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setValue(0, attrib1);
        inst.setValue(1, attrib2);
        inst.setValue(2, attrib3);
        inst.setDataset((Instances)header);
        inst.setClassValue((double)group);
        return inst;
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
        this.nextClassShouldBeZero = false;
    }

    public void getDescription(StringBuilder sb, int indent) {
    }

    protected static interface ClassFunction {
        public int determineClass(double var1, double var3, double var5);
    }
}

