/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableCell;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.ODFLoader;

public class ODFSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7446832500561589653L;
    protected String m_MissingValue = "";

    public ODFSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in ODF spreadsheet format.\nFor instance for spreadsheets that can be read with OpenOffice.org.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption((char)'M', (String[])options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-M");
        result.add(this.getMissingValue());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '' (empty cell).";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(ODFLoader.FILE_EXTENSION);
        this.setMissingValue("");
    }

    public String getFileDescription() {
        return ODFLoader.FILE_DESCRIPTION;
    }

    public String[] getFileExtensions() {
        return new String[]{ODFLoader.FILE_EXTENSION};
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        try {
            OdfTableCell cell;
            Instances data = this.getInstances();
            OdfSpreadsheetDocument outputDocument = OdfSpreadsheetDocument.newSpreadsheetDocument();
            List tables = outputDocument.getTableList();
            for (OdfTable t : tables) {
                t.remove();
            }
            OdfTable table = OdfTable.newTable((OdfDocument)outputDocument, (int)(data.numInstances() + 1), (int)data.numAttributes());
            table.setTableName(data.relationName());
            OdfTableRow row = table.getRowByIndex(0);
            for (int i = 0; i < data.numAttributes(); ++i) {
                cell = row.getCellByIndex(i);
                cell.setStringValue(data.attribute(i).name());
            }
            for (int n = 0; n < data.numInstances(); ++n) {
                row = table.getRowByIndex(n + 1);
                Instance inst = data.instance(n);
                block9: for (int i = 0; i < data.numAttributes(); ++i) {
                    cell = row.getCellByIndex(i);
                    if (inst.isMissing(i)) {
                        if (this.m_MissingValue.length() <= 0) continue;
                        cell.setStringValue(this.m_MissingValue);
                        continue;
                    }
                    switch (data.attribute(i).type()) {
                        case 0: {
                            cell.setDoubleValue(Double.valueOf(inst.value(i)));
                            continue block9;
                        }
                        case 1: 
                        case 2: {
                            cell.setStringValue(inst.stringValue(i));
                            continue block9;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled attribute type: " + data.attribute(i).type());
                        }
                    }
                }
            }
            if (this.retrieveFile() == null) {
                outputDocument.save((OutputStream)System.out);
            } else {
                outputDocument.save(this.retrieveFile());
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 6917 $");
    }

    public static void main(String[] args) {
        ODFSaver.runFileSaver((AbstractFileSaver)new ODFSaver(), (String[])args);
    }
}

