/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.CheckOptionHandler;
import weka.core.ClassDiscovery;
import weka.core.OptionHandler;
import weka.gui.GenericPropertiesCreator;

public class OptionHandlersTest
extends TestCase {
    public OptionHandlersTest(String name) {
        super(name);
    }

    public void testDummy() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        try {
            Vector<String> testMethods = new Vector<String>();
            Method[] methods = OptionHandlerTest.class.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().startsWith("test")) {
                    testMethods.add(methods[i].getName());
                }
                ++i;
            }
            GenericPropertiesCreator creator = new GenericPropertiesCreator();
            creator.execute(false);
            Properties props = creator.getOutputProperties();
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement().toString();
                StringTokenizer tok = new StringTokenizer(props.getProperty(name, ""), ",");
                while (tok.hasMoreTokens()) {
                    String classname = tok.nextToken();
                    try {
                        Class<?> cls = Class.forName(classname);
                        if (!ClassDiscovery.hasInterface(OptionHandler.class, cls)) {
                        }
                    }
                    catch (Exception e) {}
                    continue;
                    int i2 = 0;
                    while (i2 < testMethods.size()) {
                        suite.addTest((Test)new OptionHandlerTest((String)testMethods.get(i2), classname));
                        ++i2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return suite;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)OptionHandlersTest.suite());
    }

    public static class OptionHandlerTest
    extends TestCase {
        protected String m_Classname;
        protected CheckOptionHandler m_OptionTester;

        public OptionHandlerTest(String name, String classname) {
            super(name);
            this.m_Classname = classname;
        }

        public String getClassname() {
            return this.m_Classname;
        }

        protected OptionHandler getOptionHandler() {
            OptionHandler result;
            try {
                result = (OptionHandler)Class.forName(this.m_Classname).newInstance();
            }
            catch (Exception e) {
                result = null;
            }
            return result;
        }

        protected void setUp() throws Exception {
            super.setUp();
            this.m_OptionTester = new CheckOptionHandler();
            this.m_OptionTester.setOptionHandler(this.getOptionHandler());
            this.m_OptionTester.setUserOptions(new String[0]);
            this.m_OptionTester.setSilent(true);
        }

        protected void tearDown() throws Exception {
            super.tearDown();
            this.m_OptionTester = null;
        }

        public void testListOptions() throws Exception {
            if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
                OptionHandlerTest.fail((String)(String.valueOf(this.getClassname()) + ": " + "Options cannot be listed via listOptions."));
            }
        }

        public void testSetOptions() throws Exception {
            if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
                OptionHandlerTest.fail((String)(String.valueOf(this.getClassname()) + ": " + "setOptions method failed."));
            }
        }

        public void testRemainingOptions() throws Exception {
            if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
                OptionHandlerTest.fail((String)(String.valueOf(this.getClassname()) + ": " + "There were 'left-over' options."));
            }
        }

        public void testCanonicalUserOptions() throws Exception {
            if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
                OptionHandlerTest.fail((String)(String.valueOf(this.getClassname()) + ": " + "setOptions method failed"));
            }
        }

        public void testResettingOptions() throws Exception {
            if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
                OptionHandlerTest.fail((String)(String.valueOf(this.getClassname()) + ": " + "Resetting of options failed"));
            }
        }
    }
}

