/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SwapValues;

public class SwapValuesTest
extends AbstractFilterTest {
    public SwapValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        SwapValues f = new SwapValues();
        f.setAttributeIndex("2");
        return f;
    }

    public void testInvalidAttributeTypes() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((SwapValues)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            SwapValuesTest.fail((String)"Should have thrown an exception selecting a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((SwapValues)this.m_Filter).setAttributeIndex("3");
            this.m_Filter.setInputFormat(icopy);
            SwapValuesTest.fail((String)"Should have thrown an exception indicating a NUMERIC attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testTypical() {
        Instances result = this.useFilter();
        SwapValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SwapValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean first = false;
        int second = 2;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(1) == (double)first) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)second ? 1 : 0) != 0);
            } else if (this.m_Instances.instance(i).value(1) == (double)second) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)first ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testFirstValueIndex() {
        ((SwapValues)this.m_Filter).setFirstValueIndex("2");
        Instances result = this.useFilter();
        SwapValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SwapValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean first = true;
        int second = 2;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(1) == (double)first) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)second ? 1 : 0) != 0);
            } else if (this.m_Instances.instance(i).value(1) == (double)second) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)first ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testSecondValueIndex() {
        ((SwapValues)this.m_Filter).setSecondValueIndex("2");
        Instances result = this.useFilter();
        SwapValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SwapValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean first = false;
        boolean second = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).value(1) == (double)first) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)second ? 1 : 0) != 0);
            } else if (this.m_Instances.instance(i).value(1) == (double)second) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(1) == (double)first ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testAttributeWithMissing() {
        ((SwapValues)this.m_Filter).setAttributeIndex("5");
        ((SwapValues)this.m_Filter).setFirstValueIndex("1");
        ((SwapValues)this.m_Filter).setSecondValueIndex("2");
        Instances result = this.useFilter();
        SwapValuesTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        SwapValuesTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        boolean first = false;
        boolean second = true;
        int i = 0;
        while (i < result.numInstances()) {
            if (this.m_Instances.instance(i).isMissing(4)) {
                SwapValuesTest.assertTrue((String)("Missing in input should give missing in result:" + this.m_Instances.instance(i) + " --> " + result.instance(i)), (boolean)result.instance(i).isMissing(4));
            } else if (this.m_Instances.instance(i).value(4) == (double)first) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(4) == (double)second ? 1 : 0) != 0);
            } else if (this.m_Instances.instance(i).value(4) == (double)second) {
                SwapValuesTest.assertTrue((String)"Value should be swapped", (result.instance(i).value(4) == (double)first ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((SwapValues)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            SwapValuesTest.fail((String)("Problem setting up test for FilteredClassifier: " + e.toString()));
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(SwapValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SwapValuesTest.suite());
    }
}

