/*
 * Decompiled with CFR 0.152.
 */
package weka.test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;

public class Regression {
    private static final String FILE_EXTENSION = ".ref";
    private static final String ROOT_PROPERTY = "weka.test.Regression.root";
    private static final String DEFAULT_ROOT = "wekarefs";
    private static File ROOT;
    private StringBuffer m_Output;
    private File m_RefFile;

    public static File getRoot() {
        if (ROOT == null) {
            String root = System.getProperty(ROOT_PROPERTY);
            if (root == null) {
                root = System.getProperty("user.dir");
                ROOT = new File(root, DEFAULT_ROOT);
            } else {
                ROOT = new File(root);
            }
        }
        return ROOT;
    }

    public Regression(Class theClass) {
        if (theClass == null) {
            throw new NullPointerException();
        }
        String relative = String.valueOf(theClass.getName().replace('.', File.separatorChar)) + FILE_EXTENSION;
        this.m_RefFile = new File(Regression.getRoot(), relative);
        this.m_Output = new StringBuffer();
    }

    public void println(String output) {
        this.m_Output.append(output).append('\n');
    }

    public String diff() throws IOException {
        try {
            String reference = this.readReference();
            return this.diff(reference, this.m_Output.toString());
        }
        catch (FileNotFoundException fnf) {
            this.writeAsReference();
            return null;
        }
    }

    protected String diff(String reference, String current) {
        if (reference.equals(current)) {
            return "";
        }
        StringBuffer diff = new StringBuffer();
        diff.append("+++ Reference: ").append(this.m_RefFile).append(" +++\n").append(reference).append("+++ Current +++\n").append(current).append("+++\n");
        return diff.toString();
    }

    protected String readReference() throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(this.m_RefFile));
        StringBuffer ref = new StringBuffer();
        char[] buf = new char[5];
        int read = r.read(buf);
        while (read > 0) {
            ref.append(new String(buf, 0, read));
            read = r.read(buf);
        }
        ((Reader)r).close();
        return ref.toString();
    }

    public void writeAsReference() throws IOException {
        File parent = this.m_RefFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(this.m_RefFile));
        w.write(this.m_Output.toString());
        ((Writer)w).close();
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("Usage: Regression \"some text\"");
            }
            Properties props = System.getProperties();
            props.setProperty(ROOT_PROPERTY, props.getProperty("java.io.tmpdir"));
            Regression reg = new Regression(Regression.class);
            int i = 0;
            while (i < args.length) {
                reg.println(args[i]);
                ++i;
            }
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Created reference output");
            } else if (diff.equals("")) {
                System.err.println("Passed");
            } else {
                System.err.println("Failed: " + diff);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

